/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server.impl;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingUp;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.event.WorldEventFuture;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.unreal.server.exception.MapChangeException;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetGameSpeed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MutatorListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.impl.AbstractUT2004Server;
import cz.cuni.amis.utils.Job;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class UT2004Server
extends AbstractUT2004Server<UT2004WorldView, IAct>
implements IUT2004Server {
    public static final int MAX_CHANGING_MAP_ATTEMPTS = 20;
    public static final int MAP_CHANGE_CONNECT_INTERVAL_MILLIS = 1000;
    private volatile BusAwareCountDownLatch mapLatch = null;
    protected IWorldEventListener<PlayerJoinsGame> playerJoinsListener = null;
    protected IWorldEventListener<MapListObtained> mapListListener = null;
    private UT2004AgentParameters params;
    protected Object changingMapMutex = new Object();
    protected boolean changingMap = false;
    protected int changingMapAttempt = 0;
    protected String targetMap = null;
    protected MapChangeFuture mapChangeFuture = null;

    @Inject
    public UT2004Server(UT2004AgentParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params.getAgentId(), agentLogger, bus, connection, worldView, act);
        this.params = params;
        this.mapLatch = new BusAwareCountDownLatch(1, this.getEventBus(), new IComponent[]{worldView});
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(MutatorListObtained.class, (IWorldEventListener)new IWorldEventListener<MutatorListObtained>(){

            public void notify(MutatorListObtained event) {
                UT2004Server.this.mutators = event.getMutators();
            }
        });
        this.gameSpeed.addListener((FlagListener)new FlagListener<Double>(){

            public void flagChanged(Double changedValue) {
                UT2004Server.this.getAct().act((CommandMessage)new SetGameSpeed(changedValue));
            }
        });
        this.mapListListener = new IWorldEventListener<MapListObtained>(){

            public void notify(MapListObtained event) {
                UT2004Server.this.maps = event.getMaps();
                UT2004Server.this.getAct().act((CommandMessage)new StartPlayers(true, true, true));
                UT2004Server.this.mapLatch.countDown();
            }
        };
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(MapListObtained.class, (IWorldEventListener)this.mapListListener);
    }

    public UT2004AgentParameters getParams() {
        return this.params;
    }

    @Override
    protected void startAgent() {
        boolean succeded;
        super.startAgent();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Waiting for the map list to arrive...");
        }
        if (!(succeded = this.mapLatch.await(60000L, TimeUnit.MILLISECONDS))) {
            throw new ComponentCantStartException("The server did not received maps in 60 seconds.", (IComponent)this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Maps received.");
        }
        this.init();
    }

    @Override
    protected void startPausedAgent() {
        boolean succeded;
        super.startPausedAgent();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Waiting for the map list to arrive...");
        }
        if (!(succeded = this.mapLatch.await(60000L, TimeUnit.MILLISECONDS))) {
            throw new ComponentCantStartException("The server did not received maps in 60 seconds.", (IComponent)this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Maps received.");
        }
    }

    protected void init() {
    }

    @Override
    protected void reset() {
        super.reset();
        this.mapLatch = new BusAwareCountDownLatch(1, this.getEventBus(), new IComponent[]{this.getWorldView()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> setGameMap(String map) throws MapChangeException {
        try {
            Object object = this.changingMapMutex;
            synchronized (object) {
                if (!this.inState(new Class[]{IAgentStateUp.class})) {
                    throw new MapChangeException("Can't change map as we're not connected to GB2004 server.", (Object)this);
                }
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Changing map to '" + map + "'");
                }
                WorldEventFuture mapChangeLatch = new WorldEventFuture(this.getWorldView(), MapChange.class);
                this.changingMap = true;
                this.changingMapAttempt = 0;
                this.targetMap = map;
                this.mapChangeFuture = new MapChangeFuture();
                this.getAct().act((CommandMessage)new ChangeMap().setMapName(map));
                if (mapChangeLatch.get(20000L, TimeUnit.MILLISECONDS) == null) {
                    throw new MapChangeException("ChangeMap sent but GB2004 failed to response with MapChange message in 20sec.", (Object)this);
                }
                return this.mapChangeFuture;
            }
        }
        catch (Exception e) {
            throw new MapChangeException("Can't change map to " + map + ".", (Throwable)e);
        }
    }

    public void connectNativeBot(String botName, String botType) {
        super.connectNativeBot(botName, botType, 0);
    }

    private class MapChangeRestartServerJob
    extends Job<Boolean> {
        private MapChangeRestartServerJob() {
        }

        protected void job() throws Exception {
            try {
                UT2004Server.this.stop();
            }
            catch (Exception e) {
                UT2004Server.this.kill();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            UT2004Server.this.start();
            this.setResult(true);
        }
    }

    public class MapChangeFuture
    implements Future<Boolean> {
        boolean canceled = false;
        Boolean success = null;
        CountDownLatch doneLatch = new CountDownLatch(1);
        IAgentState lastState = null;
        FlagListener<IAgentState> listener = new FlagListener<IAgentState>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flagChanged(IAgentState changedValue) {
                if (MapChangeFuture.this.lastState != null && MapChangeFuture.this.lastState.getClass().isAssignableFrom(changedValue.getClass())) {
                    return;
                }
                MapChangeFuture.this.lastState = changedValue;
                if (changedValue instanceof IAgentStateGoingUp) {
                    ++UT2004Server.this.changingMapAttempt;
                    if (UT2004Server.this.log.isLoggable(Level.WARNING)) {
                        UT2004Server.this.log.warning("Map change attempt: " + UT2004Server.this.changingMapAttempt + " / " + 20);
                    }
                } else if (changedValue instanceof IAgentStateDown) {
                    if (UT2004Server.this.changingMapAttempt >= 20) {
                        Object object = UT2004Server.this.changingMapMutex;
                        synchronized (object) {
                            UT2004Server.this.changingMap = false;
                            UT2004Server.this.changingMapAttempt = 0;
                            UT2004Server.this.targetMap = null;
                            UT2004Server.this.mapChangeFuture = null;
                            MapChangeFuture.this.success = false;
                            MapChangeFuture.this.doneLatch.countDown();
                            UT2004Server.this.getState().removeListener((FlagListener)this);
                        }
                    } else {
                        MapChangeRestartServerJob restartServer = new MapChangeRestartServerJob();
                        restartServer.startJob();
                    }
                } else if (changedValue instanceof IAgentStateUp) {
                    if (UT2004Server.this.getMapName() == null || !UT2004Server.this.getMapName().equalsIgnoreCase(UT2004Server.this.targetMap)) {
                        if (UT2004Server.this.log.isLoggable(Level.WARNING)) {
                            UT2004Server.this.log.warning("Reconnected to GB2004 but the map was not changed to '" + UT2004Server.this.targetMap + "' yet.");
                        }
                        MapChangeRestartServerJob restartServer = new MapChangeRestartServerJob();
                        restartServer.startJob();
                    } else {
                        MapChangeFuture.this.success = true;
                        MapChangeFuture.this.doneLatch.countDown();
                        UT2004Server.this.getState().removeListener((FlagListener)this);
                    }
                }
            }
        };

        protected MapChangeFuture() {
            UT2004Server.this.getState().addListener(this.listener);
        }

        public void restartServer() {
            new MapChangeRestartServerJob().startJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean arg0) {
            Object object = UT2004Server.this.changingMapMutex;
            synchronized (object) {
                UT2004Server.this.changingMap = false;
                UT2004Server.this.changingMapAttempt = 0;
                UT2004Server.this.targetMap = null;
                UT2004Server.this.mapChangeFuture = null;
                this.success = false;
                this.canceled = true;
                this.doneLatch.countDown();
            }
            return false;
        }

        @Override
        public Boolean get() {
            try {
                this.doneLatch.await();
            }
            catch (InterruptedException e) {
                new PogamutInterruptedException("Interrupted while waiting for the map change to finish.", (Object)e);
            }
            return this.success;
        }

        @Override
        public Boolean get(long arg0, TimeUnit arg1) {
            try {
                this.doneLatch.await(arg0, arg1);
            }
            catch (InterruptedException e) {
                new PogamutInterruptedException("Interrupted while waiting for the map change to finish.", (Object)e);
            }
            return this.success;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            return this.doneLatch.getCount() <= 0L;
        }
    }
}

