/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.BSPRayInfoContainer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;

public class RaycastingBSP
extends SensomotoricModule<UT2004Bot> {
    Map<String, BSPRayInfoContainer> rayInfoContainers = new HashMap<String, BSPRayInfoContainer>();
    int counter = 0;
    private String idSuffix;
    LevelGeometry levelGeometry = null;
    private IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            RaycastingBSP.this.selfUpdate((Self)event.getObject());
        }
    };

    public RaycastingBSP(UT2004Bot bot) {
        this(bot, null);
    }

    public RaycastingBSP(UT2004Bot bot, Logger log) {
        super((IEmbodiedAgent)bot, log);
        this.idSuffix = "_" + bot.getName() + UUID.randomUUID().toString();
        bot.getWorldView().addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.selfListener);
        if (bot.getNavMesh() != null) {
            this.levelGeometry = bot.getNavMesh().getLevelGeometry();
        }
    }

    public boolean isUsable() {
        return this.levelGeometry != null;
    }

    public void clear() {
        for (BSPRayInfoContainer rayInfo : this.rayInfoContainers.values()) {
            UnrealId unrealId;
            if (rayInfo == null || (unrealId = rayInfo.unrealId) == null) continue;
            final AutoTraceRay ray = (AutoTraceRay)((UT2004Bot)this.agent).getWorldView().get((WorldObjectId)unrealId, AutoTraceRay.class);
            ((UT2004Bot)this.agent).getWorldView().notifyImmediately((IWorldChangeEvent)new IWorldObjectUpdatedEvent(){

                public WorldObjectId getId() {
                    return ray.getId();
                }

                public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject obj) {
                    return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.DESTROYED, obj);
                }

                public long getSimTime() {
                    return ray.getSimTime();
                }
            });
        }
        this.rayInfoContainers.clear();
    }

    public Future<AutoTraceRay> createRay(Vector3d direction, int length, boolean floorCorrection) {
        String id = this.counter++ + this.idSuffix;
        return this.createRay(id, direction, length, floorCorrection);
    }

    public Future<AutoTraceRay> createRay(String id, Vector3d direction, int length, boolean floorCorrection) {
        UnrealId unrealId = UnrealId.get((String)id);
        BSPRayInfoContainer rayInfo = new BSPRayInfoContainer(unrealId, direction, length, floorCorrection);
        this.rayInfoContainers.put(id, rayInfo);
        this.selfUpdate(((UT2004Bot)this.agent).getSelf());
        return null;
    }

    protected void selfUpdate(Self self) {
        for (BSPRayInfoContainer rayInfo : this.rayInfoContainers.values()) {
            AutoTraceRay ray = this.levelGeometry.getAutoTraceRayMessage(self, rayInfo);
            ((UT2004Bot)this.agent).getWorldView().notifyImmediately((IWorldChangeEvent)ray);
        }
    }

    AutoTraceRay getRay(String rayID) {
        BSPRayInfoContainer rayInfo = this.rayInfoContainers.get(rayID);
        if (rayInfo == null) {
            return null;
        }
        UnrealId unrealId = rayInfo.unrealId;
        if (unrealId == null) {
            return null;
        }
        AutoTraceRay ray = (AutoTraceRay)((UT2004Bot)this.agent).getWorldView().get((WorldObjectId)unrealId, AutoTraceRay.class);
        return ray;
    }
}

