/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.astar.UT2004AStar;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.maps.CountIntMap;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class UT2004PathAutoFixer {
    public static final int REAMOVE_EDGE_AFTER_N_FAILURES_DEFAULT = 2;
    private IUT2004PathExecutor<? extends ILocated> pathExecutor;
    private FloydWarshallMap fwMap;
    private UT2004AStar aStar;
    private NavigationGraphBuilder navBuilder;
    private CountIntMap<NavPointNeighbourLink> badLinks = new CountIntMap();
    private Set<NavPointNeighbourLink> removedLinks = new HashSet<NavPointNeighbourLink>();
    private LogCategory log;
    private int removeBadEdgeAfterNFailures;
    private boolean botHarmed;
    private IWorldEventListener<BotDamaged> botDamagedListener = new IWorldEventListener<BotDamaged>(){

        public void notify(BotDamaged event) {
            UT2004PathAutoFixer.this.botDamaged();
        }
    };
    private IWorldEventListener<BotKilled> botKilledListener = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            UT2004PathAutoFixer.this.botKilled();
        }
    };
    private Listeners<ILinkRemovalListener> linkRemovalListeners = new Listeners();
    public NavPointNeighbourLink listenerLink;
    public boolean listenersLinkCanRemove = true;
    private Listeners.ListenerNotifier<ILinkRemovalListener> canRemoveLinkNotifier = new Listeners.ListenerNotifier<ILinkRemovalListener>(){

        public NavPointNeighbourLink getEvent() {
            return UT2004PathAutoFixer.this.listenerLink;
        }

        public void notify(ILinkRemovalListener listener) {
            UT2004PathAutoFixer.this.listenersLinkCanRemove = UT2004PathAutoFixer.this.listenersLinkCanRemove && listener.canRemoveLink(UT2004PathAutoFixer.this.listenerLink);
        }
    };
    private Listeners.ListenerNotifier<ILinkRemovalListener> linkRemovedNotifier = new Listeners.ListenerNotifier<ILinkRemovalListener>(){

        public NavPointNeighbourLink getEvent() {
            return UT2004PathAutoFixer.this.listenerLink;
        }

        public void notify(ILinkRemovalListener listener) {
            listener.linkRemoved(UT2004PathAutoFixer.this.listenerLink);
        }
    };

    public UT2004PathAutoFixer(UT2004Bot bot, IUT2004PathExecutor<? extends ILocated> pathExecutor, FloydWarshallMap fwMap, UT2004AStar aStar, NavigationGraphBuilder navBuilder) {
        this(bot, pathExecutor, fwMap, aStar, navBuilder, 2);
    }

    public UT2004PathAutoFixer(UT2004Bot bot, IUT2004PathExecutor<? extends ILocated> pathExecutor, FloydWarshallMap fwMap, UT2004AStar aStar, NavigationGraphBuilder navBuilder, int removeBadEdgeAfterNFailures) {
        if (removeBadEdgeAfterNFailures < 1) {
            throw new IllegalArgumentException("removeBadEdgeAfterNFailures == " + removeBadEdgeAfterNFailures + " < 1 cannot be!");
        }
        this.log = bot.getLogger().getCategory(UT2004PathAutoFixer.class.getSimpleName());
        this.pathExecutor = pathExecutor;
        this.fwMap = fwMap;
        this.aStar = aStar;
        this.navBuilder = navBuilder;
        NullCheck.check(this.pathExecutor, (String)"pathExecutor");
        NullCheck.check((Object)((Object)this.navBuilder), (String)"navBuilder");
        this.removeBadEdgeAfterNFailures = removeBadEdgeAfterNFailures;
        this.pathExecutor.getState().addListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                switch (changedValue.getState()) {
                    case PATH_COMPUTED: {
                        UT2004PathAutoFixer.this.pathComputed();
                        return;
                    }
                    case SWITCHED_TO_ANOTHER_PATH_ELEMENT: {
                        UT2004PathAutoFixer.this.switchedToNewElement();
                        return;
                    }
                    case STUCK: {
                        UT2004PathAutoFixer.this.stuck();
                        return;
                    }
                }
            }
        });
        bot.getWorldView().addEventListener(BotDamaged.class, this.botDamagedListener);
        bot.getWorldView().addEventListener(BotKilled.class, this.botKilledListener);
    }

    protected void botDamaged() {
        this.botHarmed = true;
    }

    protected void botKilled() {
        this.botHarmed = true;
    }

    protected void switchedToNewElement() {
        this.botHarmed = false;
    }

    protected void pathComputed() {
        this.botHarmed = false;
    }

    protected void stuck() {
        if (this.botHarmed) {
            return;
        }
        NavPointNeighbourLink link = this.pathExecutor.getCurrentLink();
        if (link == null) {
            return;
        }
        this.badLinks.increase((Object)link);
        this.checkRemove(link);
    }

    protected void checkRemove(NavPointNeighbourLink link) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Bot has stuck (" + this.badLinks.get((Object)link) + "x) on link " + (Object)((Object)link));
        }
        if (this.badLinks.get((Object)link) >= this.removeBadEdgeAfterNFailures) {
            this.listenerLink = link;
            this.listenersLinkCanRemove = true;
            this.linkRemovalListeners.notify(this.canRemoveLinkNotifier);
            if (this.listenersLinkCanRemove) {
                this.removeLink(link);
            } else if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Some listener prevented link from removal: " + (Object)((Object)link));
            }
        }
    }

    protected void removeLink(NavPointNeighbourLink link) {
        String fromId = link.getFromNavPoint().getId().getStringId();
        String toId = link.getToNavPoint().getId().getStringId();
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("REMOVING EDGE FROM NAV-GRAPTH (affects fwMap): " + fromId + " -> " + toId);
        }
        this.navBuilder.removeEdge(fromId, toId);
        this.removedLinks.add(link);
        if (this.fwMap != null) {
            this.fwMap.refreshPathMatrix();
        }
        if (this.aStar != null) {
            this.aStar.mapChanged();
        }
        this.listenerLink = link;
        this.linkRemovalListeners.notify(this.linkRemovedNotifier);
    }

    public Set<NavPointNeighbourLink> getRemovedLinks() {
        return this.removedLinks;
    }

    public CountIntMap<NavPointNeighbourLink> getBadLinks() {
        return this.badLinks;
    }

    public void addListener(ILinkRemovalListener listener) {
        this.linkRemovalListeners.addStrongListener((EventListener)listener);
    }

    public void removeListener(ILinkRemovalListener listener) {
        this.linkRemovalListeners.removeListener((EventListener)listener);
    }

    public boolean isListener(ILinkRemovalListener listener) {
        return this.linkRemovalListeners.isListening((EventListener)listener);
    }

    public static interface ILinkRemovalListener
    extends EventListener {
        public boolean canRemoveLink(NavPointNeighbourLink var1);

        public void linkRemoved(NavPointNeighbourLink var1);
    }
}

