/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LocationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.StringProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.VelocityProperty;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MoverShared;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MoverSharedImpl
extends MoverShared {
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(3);
    protected UnrealId Id = null;
    protected LocationProperty myLocation = null;
    protected VelocityProperty myVelocity = null;
    protected StringProperty myState = null;

    public MoverSharedImpl(MoverSharedImpl source) {
        this.Id = source.getId();
        this.myLocation = source.myLocation;
        this.myVelocity = source.myVelocity;
        this.myState = source.myState;
    }

    public MoverSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
        this.Id = (UnrealId)objectId;
        NullCheck.check((Object)this.Id, (String)"objectId");
        if (properties.size() != 3) {
            throw new PogamutException("Not enough properties passed to the constructor.", MoverSharedImpl.class);
        }
        for (ISharedProperty property : properties) {
            PropertyId pId = property.getPropertyId();
            if (!objectId.equals((Object)property.getObjectId())) {
                throw new PogamutException("Trying to create a MoverSharedImpl with different WorldObjectId properties : " + this.Id.getStringId() + " / " + property.getObjectId().getStringId(), (Object)this);
            }
            if (!MoverShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
                throw new PogamutException("Trying to create a MoverSharedImpl with invalid property (invalid property token): " + this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken(), (Object)this);
            }
            this.propertyMap.put(property.getPropertyId(), property);
            if (pId.getPropertyToken().getToken().equals("Location")) {
                this.myLocation = (LocationProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Velocity")) {
                this.myVelocity = (VelocityProperty)property;
            }
            if (!pId.getPropertyToken().getToken().equals("State")) continue;
            this.myState = (StringProperty)property;
        }
    }

    @Override
    public void setSimTime(long SimTime) {
        super.setSimTime(SimTime);
    }

    @Override
    public MoverSharedImpl clone() {
        return new MoverSharedImpl(this);
    }

    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public Location getLocation() {
        return (Location)this.myLocation.getValue();
    }

    @Override
    public Velocity getVelocity() {
        return (Velocity)this.myVelocity.getValue();
    }

    @Override
    public String getState() {
        return (String)this.myState.getValue();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Velocity = " + String.valueOf(this.getVelocity()) + " | " + "State = " + String.valueOf(this.getState()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> " + "<b>State</b> = " + String.valueOf(this.getState()) + " <br/> " + "<br/>]";
    }

    public static class MoverSharedUpdate
    implements ISharedWorldObjectUpdatedEvent {
        private MoverShared object;
        private long time;
        private ITeamId teamId;

        public MoverSharedUpdate(MoverShared data, long time, ITeamId teamId) {
            this.object = data;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ITeamId getTeamId() {
            return this.teamId;
        }

        public Class getCompositeObjectClass() {
            return this.object.getCompositeClass();
        }

        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty property : this.object.getProperties().values()) {
                if (property == null) continue;
                events.push(property.createUpdateEvent(this.time, this.teamId));
            }
            return events;
        }
    }
}

