/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.HashCode;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.SafeEquals;

public class NavLinkPair {
    private NavPointNeighbourLink link1;
    private NavPointNeighbourLink link2;
    private NavPoint nav1;
    private NavPoint nav2;
    private Location x1;
    private Location x2;
    private int hashCode;

    public NavLinkPair(NavPointNeighbourLink first) {
        this.link1 = first;
        NullCheck.check((Object)((Object)this.link1), (String)"first");
        HashCode hc = new HashCode();
        hc.add(((Object)((Object)this.link1)).hashCode());
        this.hashCode = hc.getHash();
        this.nav1 = this.link1.getFromNavPoint();
        this.nav2 = this.link1.getToNavPoint();
        this.x1 = this.link1.getFromNavPoint().getLocation();
        this.x2 = this.link1.getToNavPoint().getLocation();
    }

    public NavLinkPair(NavPointNeighbourLink first, NavPointNeighbourLink second) {
        if (first == null) {
            first = second;
            second = null;
        } else if (second != null && ((Object)((Object)first)).hashCode() > ((Object)((Object)second)).hashCode()) {
            NavPointNeighbourLink temp = second;
            second = first;
            first = temp;
        }
        this.link1 = first;
        this.link2 = second;
        NullCheck.check((Object)((Object)this.link1), (String)"'first' and 'second'");
        HashCode hc = new HashCode();
        hc.add(((Object)((Object)this.link1)).hashCode());
        if (this.link2 != null) {
            hc.add(((Object)((Object)this.link2)).hashCode());
        }
        this.hashCode = hc.getHash();
        this.nav1 = this.link1.getFromNavPoint();
        this.nav2 = this.link1.getToNavPoint();
        this.x1 = this.nav1.getLocation();
        this.x2 = this.nav2.getLocation();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NavLinkPair)) {
            return false;
        }
        if (this.hashCode != obj.hashCode()) {
            return false;
        }
        NavLinkPair pair = (NavLinkPair)obj;
        return SafeEquals.equals((Object)((Object)this.link1), (Object)((Object)pair.getNavLink1())) && SafeEquals.equals((Object)((Object)this.link2), (Object)((Object)pair.getNavLink2()));
    }

    public NavPointNeighbourLink getNavLink1() {
        return this.link1;
    }

    public NavPointNeighbourLink getNavLink2() {
        return this.link2;
    }

    public NavPoint getNavPoint1() {
        return this.nav1;
    }

    public NavPoint getNavPoint2() {
        return this.nav2;
    }

    public boolean isLinkNavPoint(NavPoint navPoint) {
        if (navPoint == null) {
            return false;
        }
        return SafeEquals.equals((Object)navPoint.getId(), (Object)this.nav1.getId()) || SafeEquals.equals((Object)navPoint.getId(), (Object)this.nav2.getId());
    }

    public boolean isLinkNavPoint(UnrealId navPointId) {
        if (navPointId == null) {
            return false;
        }
        return SafeEquals.equals((Object)navPointId, (Object)this.nav1.getId()) || SafeEquals.equals((Object)navPointId, (Object)this.nav2.getId());
    }

    public NavPointNeighbourLink getLinkLeadingTo(UnrealId navPointLinkEndsInId) {
        if (navPointLinkEndsInId == null) {
            return null;
        }
        if (this.link1 != null && this.link1.getToNavPoint() != null && this.link1.getToNavPoint().getId().equals((Object)navPointLinkEndsInId)) {
            return this.link1;
        }
        if (this.link2 != null && this.link2.getToNavPoint() != null && this.link2.getToNavPoint().getId().equals((Object)navPointLinkEndsInId)) {
            return this.link1;
        }
        return null;
    }

    public NavPointNeighbourLink getLinkComingFrom(UnrealId navPointLinkIsComingFromId) {
        if (navPointLinkIsComingFromId == null) {
            return null;
        }
        if (this.link1 != null && this.link1.getFromNavPoint() != null && this.link1.getFromNavPoint().getId().equals((Object)navPointLinkIsComingFromId)) {
            return this.link1;
        }
        if (this.link2 != null && this.link2.getFromNavPoint() != null && this.link2.getFromNavPoint().getId().equals((Object)navPointLinkIsComingFromId)) {
            return this.link1;
        }
        return null;
    }

    public NavPointNeighbourLink getLinkLeadingTo(NavPoint navPointLinkEndsIn) {
        if (navPointLinkEndsIn == null) {
            return null;
        }
        if (this.link1 != null && this.link1.getToNavPoint() != null && this.link1.getToNavPoint().getId().equals((Object)navPointLinkEndsIn.getId())) {
            return this.link1;
        }
        if (this.link2 != null && this.link2.getToNavPoint() != null && this.link2.getToNavPoint().getId().equals((Object)navPointLinkEndsIn.getId())) {
            return this.link1;
        }
        return null;
    }

    public NavPointNeighbourLink getLinkComingFrom(NavPoint navPointLinkIsComingFrom) {
        if (navPointLinkIsComingFrom == null) {
            return null;
        }
        if (this.link1 != null && this.link1.getFromNavPoint() != null && this.link1.getFromNavPoint().getId().equals((Object)navPointLinkIsComingFrom.getId())) {
            return this.link1;
        }
        if (this.link2 != null && this.link2.getFromNavPoint() != null && this.link2.getFromNavPoint().getId().equals((Object)navPointLinkIsComingFrom.getId())) {
            return this.link1;
        }
        return null;
    }

    public Location getFirstVector() {
        if (this.link1 == null) {
            return null;
        }
        return this.link1.getToNavPoint().getLocation().sub(this.link1.getFromNavPoint().getLocation());
    }

    public Location getSecondVector() {
        if (this.link2 == null) {
            return null;
        }
        return this.link2.getToNavPoint().getLocation().sub(this.link2.getFromNavPoint().getLocation());
    }

    public double getDistance(ILocated point) {
        if (point == null) {
            return Double.MAX_VALUE;
        }
        if (this.x1 == null || this.x2 == null) {
            return Double.MAX_VALUE;
        }
        Location x0 = point.getLocation();
        double distance = x0.sub(this.x1).cross(x0.sub(this.x2)).getLength() / this.x2.sub(this.x1).getLength();
        return distance;
    }
}

