/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class CTF
extends SensorModule<UT2004Bot> {
    protected Self self;
    protected FlagInfo ourFlag;
    protected NavPoint ourBase;
    protected FlagInfo enemyFlag;
    protected NavPoint enemyBase;
    protected boolean enabled = false;
    protected GameInfoListener gameInfoListener;
    protected FlagUpdatedListener flagUpdatedListener;
    protected SelfUpdatedListener selfAppearedListener;
    public AgentInfo info;

    protected void setEnabled(boolean value) {
        if (value == this.enabled) {
            return;
        }
        this.enabled = value;
        if (this.enabled) {
            this.log.info("Module enabled, registering event listeners.");
        } else {
            this.log.info("Module disabled, removing event listeners.");
        }
    }

    public FlagInfo getEnemyFlag() {
        return this.enemyFlag;
    }

    public NavPoint getEnemyBase() {
        return this.enemyBase;
    }

    public boolean canEnemyTeamPossiblyScore() {
        return this.isEnemyFlagHome();
    }

    public boolean canEnemyTeamScore() {
        return this.isEnemyFlagHome() && this.isEnemyTeamCarryingOurFlag();
    }

    public boolean isEnemyTeamCarryingOurFlag() {
        return this.isOurFlagHeld();
    }

    public boolean isEnemyFlagHome() {
        return this.enemyFlag != null && this.enemyFlag.getState().toLowerCase().contains("home");
    }

    public boolean isEnemyFlagDropped() {
        return this.enemyFlag != null && this.enemyFlag.getState().toLowerCase().contains("dropped");
    }

    public boolean isEnemyFlagHeld() {
        return this.enemyFlag != null && this.enemyFlag.getState().toLowerCase().contains("held");
    }

    public FlagInfo getOurFlag() {
        return this.ourFlag;
    }

    public NavPoint getOurBase() {
        return this.ourBase;
    }

    public boolean canOurTeamPossiblyScore() {
        return this.isOurFlagHome();
    }

    public boolean canOurTeamScore() {
        return this.isOurFlagHome() && this.isOurTeamCarryingEnemyFlag();
    }

    public boolean canBotScore() {
        return this.isOurFlagHome() && this.isBotCarryingEnemyFlag();
    }

    public boolean isBotCarryingEnemyFlag() {
        return this.enemyFlag != null && this.isEnemyFlagHeld() && this.enemyFlag.getHolder() != null && this.enemyFlag.getHolder().equals((Object)this.info.getId());
    }

    public boolean isOurTeamCarryingEnemyFlag() {
        return this.isEnemyFlagHeld();
    }

    public boolean isOurFlagHome() {
        return this.ourFlag != null && this.ourFlag.getState().toLowerCase().contains("home");
    }

    public boolean isOurFlagDropped() {
        return this.ourFlag != null && this.ourFlag.getState().toLowerCase().contains("dropped");
    }

    public boolean isOurFlagHeld() {
        return this.ourFlag != null && this.ourFlag.getState().toLowerCase().contains("held");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void gameInfoSensed(GameInfo gameInfo) {
        this.setEnabled(gameInfo.getGametype() != null && gameInfo.getGametype().toLowerCase().contains("ctf"));
    }

    public void flagAppeared(FlagInfo flag) {
        if (flag.getTeam() == this.info.getTeam()) {
            this.ourFlag = flag;
            this.log.info("Got our flag: " + flag);
        } else {
            this.enemyFlag = flag;
            this.log.info("Got enemy flag: " + flag);
        }
        if (this.ourFlag != null && this.enemyFlag != null) {
            this.worldView.removeObjectListener(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.flagUpdatedListener);
        }
    }

    public void selfAppeared(Self self) {
        this.self = self;
        this.ourBase = null;
        this.enemyBase = null;
        for (NavPoint np : this.worldView.getAll(NavPoint.class).values()) {
            if (np.getId().getStringId().toLowerCase().contains("redflagbase")) {
                if (self.getTeam() == 0) {
                    this.ourBase = np;
                } else {
                    this.enemyBase = np;
                }
            } else if (np.getId().getStringId().toLowerCase().contains("blueflagbase")) {
                if (self.getTeam() == 1) {
                    this.ourBase = np;
                } else {
                    this.enemyBase = np;
                }
            }
            if (this.ourBase == null || this.enemyBase == null) continue;
            break;
        }
        this.worldView.removeObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.selfAppearedListener);
    }

    public CTF(UT2004Bot bot) {
        this(bot, new AgentInfo(bot));
    }

    public CTF(UT2004Bot bot, AgentInfo info) {
        super((IObservingAgent)bot);
        this.info = info;
        this.gameInfoListener = new GameInfoListener((IWorldView)bot.getWorldView());
        this.selfAppearedListener = new SelfUpdatedListener();
        this.worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.selfAppearedListener);
        this.flagUpdatedListener = new FlagUpdatedListener();
        this.worldView.addObjectListener(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.flagUpdatedListener);
    }

    protected void start(boolean startToPaused) {
        super.start(startToPaused);
        if (!this.worldView.isListening(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.selfAppearedListener)) {
            this.worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.selfAppearedListener);
        }
        if (!this.worldView.isListening(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.flagUpdatedListener)) {
            this.worldView.addObjectListener(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.flagUpdatedListener);
        }
    }

    protected void cleanUp() {
        super.cleanUp();
        this.ourFlag = null;
        this.enemyFlag = null;
        this.ourBase = null;
        this.enemyBase = null;
        this.setEnabled(false);
        if (!this.worldView.isListening(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.selfAppearedListener)) {
            this.worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.selfAppearedListener);
        }
        if (!this.worldView.isListening(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.flagUpdatedListener)) {
            this.worldView.addObjectListener(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this.flagUpdatedListener);
        }
    }

    protected class SelfUpdatedListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        protected SelfUpdatedListener() {
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            CTF.this.selfAppeared((Self)event.getObject());
        }
    }

    protected class FlagUpdatedListener
    implements IWorldObjectEventListener<FlagInfo, WorldObjectUpdatedEvent<FlagInfo>> {
        protected FlagUpdatedListener() {
        }

        public void notify(WorldObjectUpdatedEvent<FlagInfo> event) {
            CTF.this.flagAppeared((FlagInfo)event.getObject());
        }
    }

    protected class GameInfoListener
    implements IWorldEventListener<GameInfo> {
        public GameInfoListener(IWorldView worldView) {
            worldView.addEventListener(GameInfo.class, (IWorldEventListener)this);
        }

        public void notify(GameInfo event) {
            CTF.this.gameInfoSensed(event);
        }
    }
}

