/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.communication.module;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.UT2004CompositeObjectCreator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.UT2004SharedObjectCreator;
import cz.cuni.amis.pogamut.ut2004multi.communication.module.AgentSpecificObjectEventListener;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.WeakHashTriMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SharedKnowledgeDatabase {
    int team;
    protected static Map<Integer, SharedKnowledgeDatabase> instances = new HashMap<Integer, SharedKnowledgeDatabase>();
    protected Set<IAgentId> registeredAgents = new HashSet<IAgentId>();
    protected Map<IAgentId, IVisionWorldView> agentWorldViews = new HashMap<IAgentId, IVisionWorldView>();
    protected Map<IAgentId, Set<IWorldObjectEventListener>> listeners = new HashMap<IAgentId, Set<IWorldObjectEventListener>>();
    protected WeakHashTriMap<TimeKey, WorldObjectId, PropertyId, ISharedProperty> sharedProperties = new WeakHashTriMap();
    protected HashMapMap<WorldObjectId, PropertyId, ISharedProperty> currSharedProperties = new HashMapMap();
    protected Map<WorldObjectId, Long> lastUpdateTime = new HashMap<WorldObjectId, Long>();
    protected HashMap<TimeKey, Set<IAgentId>> heldKeys = new HashMap();
    protected Map<IAgentId, TimeKey> currentTimeKeys = new HashMap<IAgentId, TimeKey>();
    protected Set<Class> registeredClasses = new HashSet<Class>();

    protected SharedKnowledgeDatabase(int team) {
        this.team = team;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTimeLock(TimeKey timeKey, IAgentId id) {
        HashMap<TimeKey, Set<IAgentId>> hashMap = this.heldKeys;
        synchronized (hashMap) {
            Set<IAgentId> agentLocks = this.heldKeys.get(timeKey);
            if (agentLocks == null) {
                agentLocks = new HashSet<IAgentId>();
                this.heldKeys.put(timeKey, agentLocks);
            }
            for (TimeKey t : this.heldKeys.keySet()) {
                if (t.getTime() < timeKey.getTime()) continue;
                this.heldKeys.get(t).add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTimeLock(TimeKey timeKey, IAgentId id) {
        HashMap<TimeKey, Set<IAgentId>> hashMap = this.heldKeys;
        synchronized (hashMap) {
            Set<IAgentId> agentLocks = this.heldKeys.get(timeKey);
            agentLocks.remove(id);
            if (agentLocks.isEmpty()) {
                this.heldKeys.remove(timeKey);
            }
        }
    }

    public static SharedKnowledgeDatabase get(int team) {
        SharedKnowledgeDatabase instance = instances.get(team);
        if (instance == null) {
            instance = new SharedKnowledgeDatabase(team);
            instances.put(team, instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgent(IAgentId id, IVisionWorldView agentWorldView, int team) {
        if (team != this.team) {
            throw new PogamutException("Trying to add an agent of different team than the one registered with this sharedKnowledgeDatabase.", (Object)this);
        }
        Set<IAgentId> set = this.registeredAgents;
        synchronized (set) {
            if (this.registeredAgents.contains(id)) {
                return;
            }
            this.registeredAgents.add(id);
            this.agentWorldViews.put(id, agentWorldView);
            for (Class c : this.registeredClasses) {
                this.addClassListener(agentWorldView, c, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectClass(Class c) {
        Set<Class> set = this.registeredClasses;
        synchronized (set) {
            this.registeredClasses.add(c);
            for (IAgentId id : this.registeredAgents) {
                this.addClassListener(this.agentWorldViews.get(id), c, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObjectClass(Class c) {
        Set<Class> set = this.registeredClasses;
        synchronized (set) {
            return this.registeredClasses.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAgent(IAgentId id) {
        Set<IAgentId> set = this.registeredAgents;
        synchronized (set) {
            if (!this.registeredAgents.contains(id)) {
                return false;
            }
            IVisionWorldView wv = this.agentWorldViews.get(id);
            Set<IWorldObjectEventListener> listenerSet = this.listeners.get(id);
            if (listenerSet != null) {
                for (IWorldObjectEventListener listener : listenerSet) {
                    wv.removeListener((IWorldEventListener)listener);
                }
            }
            this.agentWorldViews.remove(id);
            this.registeredAgents.remove(id);
            this.listeners.remove(id);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorldObject getObject(WorldObjectId id, IAgentId agentId) {
        WeakHashTriMap<TimeKey, WorldObjectId, PropertyId, ISharedProperty> weakHashTriMap = this.sharedProperties;
        synchronized (weakHashTriMap) {
            ICompositeWorldObject agentObject = (ICompositeWorldObject)this.agentWorldViews.get(agentId).get(id);
            if (agentObject == null) {
                return null;
            }
            ILocalWorldObject localPart = agentObject.getLocal();
            IStaticWorldObject staticPart = agentObject.getStatic();
            Map properties = agentObject.getShared().getProperties();
            TimeKey timeKey = TimeKey.get((long)localPart.getSimTime());
            for (PropertyId pId : this.currSharedProperties.get((Object)id).keySet()) {
                ISharedProperty p = (ISharedProperty)this.sharedProperties.get((Object)timeKey, (Object)id, (Object)pId);
                if (p == null) {
                    p = (ISharedProperty)this.currSharedProperties.get((Object)id, (Object)pId);
                }
                properties.put(p.getPropertyId(), p);
            }
            Class msgClass = localPart.getCompositeClass();
            ISharedWorldObject sharedPart = UT2004SharedObjectCreator.create(msgClass, id, properties.values());
            return UT2004CompositeObjectCreator.createObject(localPart, sharedPart, staticPart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClassListener(IVisionWorldView wv, Class c, IAgentId agentId) {
        Map<IAgentId, Set<IWorldObjectEventListener>> map = this.listeners;
        synchronized (map) {
            AgentSpecificObjectEventListener<IWorldObject, IWorldObjectEvent<IWorldObject>> listener = new AgentSpecificObjectEventListener<IWorldObject, IWorldObjectEvent<IWorldObject>>(agentId){

                public void notify(IWorldObjectEvent<IWorldObject> event) {
                    SharedKnowledgeDatabase.this.processObjEvent(event, this.agentId);
                }
            };
            wv.addObjectListener(c, (IWorldObjectEventListener)listener);
            Set<IWorldObjectEventListener> listenerSet = this.listeners.get(agentId);
            if (listenerSet == null) {
                listenerSet = new HashSet<IWorldObjectEventListener>();
                this.listeners.put(agentId, listenerSet);
            }
            listenerSet.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processObjEvent(IWorldObjectEvent<IWorldObject> event, IAgentId agentId) {
        WeakHashTriMap<TimeKey, WorldObjectId, PropertyId, ISharedProperty> weakHashTriMap = this.sharedProperties;
        synchronized (weakHashTriMap) {
            TimeKey newTimeKey;
            TimeKey currentTime = this.currentTimeKeys.get(agentId);
            if (currentTime != null) {
                if (this.currentTimeKeys.get(agentId).getTime() < event.getSimTime()) {
                    newTimeKey = TimeKey.get((long)event.getSimTime());
                    this.removeTimeLock(this.currentTimeKeys.get(agentId), agentId);
                    this.currentTimeKeys.put(agentId, newTimeKey);
                    this.addTimeLock(newTimeKey, agentId);
                }
            } else {
                newTimeKey = TimeKey.get((long)event.getSimTime());
                this.currentTimeKeys.put(agentId, newTimeKey);
                this.addTimeLock(newTimeKey, agentId);
            }
            WorldObjectId id = event.getId();
            ISharedWorldObject sharedObj = ((ICompositeWorldObject)event.getObject()).getShared();
            long lastUpdateTime = -1L;
            if (this.lastUpdateTime.containsKey(id)) {
                lastUpdateTime = this.lastUpdateTime.get(id);
            }
            if (sharedObj.getSimTime() >= lastUpdateTime) {
                for (ISharedProperty p : sharedObj.getProperties().values()) {
                    if (p.getValue() == null) continue;
                    PropertyId propertyId = p.getPropertyId();
                    ISharedProperty old = (ISharedProperty)this.currSharedProperties.get((Object)id, (Object)propertyId);
                    for (TimeKey key : this.heldKeys.keySet()) {
                        if (this.sharedProperties.get((Object)key, (Object)id, (Object)propertyId) != null) continue;
                        this.sharedProperties.put((Object)key, (Object)id, (Object)propertyId, (Object)p);
                    }
                }
            }
        }
    }
}

