/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.IntProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LocationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.RotationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.StringProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.VelocityProperty;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerShared;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PlayerSharedImpl
extends PlayerShared {
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(8);
    protected UnrealId Id = null;
    protected StringProperty myName = null;
    protected StringProperty myAction = null;
    protected RotationProperty myRotation = null;
    protected LocationProperty myLocation = null;
    protected VelocityProperty myVelocity = null;
    protected IntProperty myTeam = null;
    protected StringProperty myWeapon = null;
    protected IntProperty myFiring = null;

    public PlayerSharedImpl(PlayerSharedImpl source) {
        this.Id = source.getId();
        this.myName = source.myName;
        this.myAction = source.myAction;
        this.myRotation = source.myRotation;
        this.myLocation = source.myLocation;
        this.myVelocity = source.myVelocity;
        this.myTeam = source.myTeam;
        this.myWeapon = source.myWeapon;
        this.myFiring = source.myFiring;
    }

    public PlayerSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
        this.Id = (UnrealId)objectId;
        NullCheck.check((Object)this.Id, (String)"objectId");
        if (properties.size() != 8) {
            throw new PogamutException("Not enough properties passed to the constructor.", PlayerSharedImpl.class);
        }
        for (ISharedProperty property : properties) {
            PropertyId pId = property.getPropertyId();
            if (!objectId.equals((Object)property.getObjectId())) {
                throw new PogamutException("Trying to create a PlayerSharedImpl with different WorldObjectId properties : " + this.Id.getStringId() + " / " + property.getObjectId().getStringId(), (Object)this);
            }
            if (!PlayerShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
                throw new PogamutException("Trying to create a PlayerSharedImpl with invalid property (invalid property token): " + this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken(), (Object)this);
            }
            this.propertyMap.put(property.getPropertyId(), property);
            if (pId.getPropertyToken().getToken().equals("Name")) {
                this.myName = (StringProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Action")) {
                this.myAction = (StringProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Rotation")) {
                this.myRotation = (RotationProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Location")) {
                this.myLocation = (LocationProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Velocity")) {
                this.myVelocity = (VelocityProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Team")) {
                this.myTeam = (IntProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Weapon")) {
                this.myWeapon = (StringProperty)property;
            }
            if (!pId.getPropertyToken().getToken().equals("Firing")) continue;
            this.myFiring = (IntProperty)property;
        }
    }

    @Override
    public void setSimTime(long SimTime) {
        super.setSimTime(SimTime);
    }

    @Override
    public PlayerSharedImpl clone() {
        return new PlayerSharedImpl(this);
    }

    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public String getName() {
        return (String)this.myName.getValue();
    }

    @Override
    public String getAction() {
        return (String)this.myAction.getValue();
    }

    @Override
    public Rotation getRotation() {
        return (Rotation)this.myRotation.getValue();
    }

    @Override
    public Location getLocation() {
        return (Location)this.myLocation.getValue();
    }

    @Override
    public Velocity getVelocity() {
        return (Velocity)this.myVelocity.getValue();
    }

    @Override
    public int getTeam() {
        return (Integer)this.myTeam.getValue();
    }

    @Override
    public String getWeapon() {
        return (String)this.myWeapon.getValue();
    }

    @Override
    public int getFiring() {
        return (Integer)this.myFiring.getValue();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Name = " + String.valueOf(this.getName()) + " | " + "Action = " + String.valueOf(this.getAction()) + " | " + "Rotation = " + String.valueOf(this.getRotation()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Velocity = " + String.valueOf(this.getVelocity()) + " | " + "Team = " + String.valueOf(this.getTeam()) + " | " + "Weapon = " + String.valueOf(this.getWeapon()) + " | " + "Firing = " + String.valueOf(this.getFiring()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Name</b> = " + String.valueOf(this.getName()) + " <br/> " + "<b>Action</b> = " + String.valueOf(this.getAction()) + " <br/> " + "<b>Rotation</b> = " + String.valueOf(this.getRotation()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> " + "<b>Team</b> = " + String.valueOf(this.getTeam()) + " <br/> " + "<b>Weapon</b> = " + String.valueOf(this.getWeapon()) + " <br/> " + "<b>Firing</b> = " + String.valueOf(this.getFiring()) + " <br/> " + "<br/>]";
    }

    public static class PlayerSharedUpdate
    implements ISharedWorldObjectUpdatedEvent {
        private PlayerShared object;
        private long time;
        private ITeamId teamId;

        public PlayerSharedUpdate(PlayerShared data, long time, ITeamId teamId) {
            this.object = data;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ITeamId getTeamId() {
            return this.teamId;
        }

        public Class getCompositeObjectClass() {
            return this.object.getCompositeClass();
        }

        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty property : this.object.getProperties().values()) {
                if (property == null) continue;
                events.push(property.createUpdateEvent(this.time, this.teamId));
            }
            return events;
        }
    }
}

