package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter;

import java.util.LinkedList;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;

public class ExpectedEventsPlanSequenceConverter implements Converter {
	protected final LinkedList<? extends EventWrapper> eventWrappers;
	private WorldViewTestContext ctx;
	
	public ExpectedEventsPlanSequenceConverter(WorldViewTestContext ctx, LinkedList<? extends EventWrapper> eventWrappers) {
		this.ctx = ctx;
		this.eventWrappers = eventWrappers;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {

		LinkedList<EventWrapperWithCallCount> mock_wrappers =
			(LinkedList<EventWrapperWithCallCount>)value;
		
		int i = 0;
		for (EventWrapperWithCallCount mock_wrapper : mock_wrappers) {
			writer.startNode("WrapperAndCount");
			
			writer.addAttribute("count",
					Integer.toString(mock_wrapper.getExpectedNumberOfCalls()));
			
			writer.startNode("Wrapper");
			context.convertAnother(mock_wrapper.getEventWrapper());
			writer.endNode();			
			
			writer.endNode();
			++i;
		}
	}

	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
		
		LinkedList<EventWrapperWithCallCount> mock_wrappers =
			new LinkedList<EventWrapperWithCallCount>();
		
		while (reader.hasMoreChildren()) {			
	    	reader.moveDown();
	    	int call_count = Integer.parseInt(reader.getAttribute("count"));
	    	reader.moveDown();

	    	EventWrapper event_wrapper =
				(EventWrapper)context.convertAnother(this, context.getRequiredType());				
			
	    	EventWrapperWithCallCount wrapper =
	    		new EventWrapperWithCallCount(ctx, event_wrapper, call_count);
	    		    	
	    	mock_wrappers.add(wrapper);		    	
			reader.moveUp();
	    	reader.moveUp();
		}
		
		return mock_wrappers;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == LinkedList.class;
	}
}
