package cz.cuni.amis.pogamut.ut2004.communication.translator.bot.transition;

import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.fsm.IFSMTransition;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.ut2004.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;

public class HandshakeEndTransition implements IFSMTransition<InfoMessage, TranslatorContext> {

	@Override
	public void init(TranslatorContext context) {
	}

	@Override
	public void restart(TranslatorContext context) {
	}

	@Override
	public void stepped(TranslatorContext context,
			IFSMState<InfoMessage, TranslatorContext> fromState,
			InfoMessage bySymbol,
			IFSMState<InfoMessage, TranslatorContext> toState) {
		long simTime = 
			(bySymbol instanceof IWorldChangeEvent ? ((IWorldChangeEvent)bySymbol).getSimTime() : 0);
		context.getEventQueue().pushEvent(new MapPointListObtained(context.getNavPoints(), context.getItems(), simTime));
	}
	
	@Override
	public String toString() {
		return getClass().getSimpleName();
	}

}
