/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.communication.worldview;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.UT2004CompositeObjectCreator;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.ILocalGBViewable;
import java.util.ArrayList;
import java.util.Collection;

public abstract class UT2004VisionLocalWorldView
extends BatchAwareLocalWorldView {
    protected Collection<ILocalGBViewable> lastBatch = new ArrayList<ILocalGBViewable>();
    protected Collection<ILocalGBViewable> currentBatch = new ArrayList<ILocalGBViewable>();

    public UT2004VisionLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView parentWorldView, ITeamedAgentId agentId) {
        super(dependencies, bus, logger, parentWorldView, agentId);
    }

    protected ICompositeWorldObject createCompositeObject(ILocalWorldObject localObject, ISharedWorldObject sharedObject, IStaticWorldObject staticObject) {
        return UT2004CompositeObjectCreator.createObject(localObject, sharedObject, staticObject);
    }

    public synchronized void notify(IWorldChangeEvent event) {
        if (event instanceof ILocalWorldObjectUpdatedEvent) {
            this.localEventNotify((ILocalWorldObjectUpdatedEvent)event);
        } else if (event instanceof ICompositeWorldObjectUpdatedEvent) {
            ILocalWorldObjectUpdatedEvent locEvent = ((ICompositeWorldObjectUpdatedEvent)event).getLocalEvent();
            if (locEvent != null) {
                this.localEventNotify(locEvent);
            }
        } else if (this.isBatchEndEvent(event)) {
            this.processBatches();
        }
        super.notify(event);
    }

    private void processBatches() {
        this.lastBatch.removeAll(this.currentBatch);
        for (ILocalGBViewable obj : this.lastBatch) {
            ILocalWorldObjectUpdatedEvent disEvent = obj.createDisappearEvent();
            super.objectUpdatedEvent(disEvent);
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayList<ILocalGBViewable>(this.lastBatch.size() + 10);
    }

    protected void localEventNotify(ILocalWorldObjectUpdatedEvent event) {
        ILocalWorldObject obj = this.getMostRecentLocalWorldObject(event.getId());
        if (obj != null && obj instanceof ILocalGBViewable) {
            this.currentBatch.add((ILocalGBViewable)obj);
        }
    }
}

