package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import java.io.Serializable;

/**
 * This class is used to describe Start poses obtained from server whe
 * STARTPOSES command is sent.
 *
 * @author vejmanm
 */
public class StartPose implements Serializable, Cloneable
{
    private Location position = null;
    private Rotation orientation = null;
    private String name = null;

    public StartPose()
    {
    }

    public StartPose(String name, Location position, Rotation orientation)
    {
        this.name = name;
        this.position = position;
        this.orientation = orientation;
    }

    @Override
    public Object clone()
    {
        return new StartPose(name, position, orientation);
    }

    public final void set(String name, Location position, Rotation orientation)
    {
        this.name = name;
        this.position = position;
        this.orientation = orientation;
    }

    public final void set(StartPose original)
    {
        this.name = original.name;
        this.position = original.position;
        this.orientation = original.orientation;
    }

//            public final void get(LinkState tplLS) {
//                
//                tplLS.link=link;
//                tplLS.value=value;
//                tplLS.torque=torque;
//            }
    public String getName()
    {
        return name;
    }

    public Location getPosition()
    {
        return position;
    }

    public Rotation getOrientation()
    {
        return orientation;
    }
}
