package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;

/**
 * Sensor message representative for Victim sensor.
 *
 * @author vejmanm
 */
public class SensorGroundTruth extends SuperSensor
{
    //public static final String type="INS";
    public static final SensorType type = SensorType.GROUND_TRUTH;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorGroundTruth()
    {
        super(type);
    }

    /**
     * Location directly from gamebots - real coordinates from the game.
     *
     * @return Returns Location from Ground Trurh sensor.
     */
    public Location getLocation()
    {
        return lastMessage.getLocations().get(0);
    }

    /**
     * Orienation directly from gamebots - real coordinates from the game.
     *
     * @return Returns Orientation from Ground Trurh sensor.
     */
    public Rotation getOrientation()
    {
        return lastMessage.getOrientations().get(0);
    }
}
