package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import java.util.Map;
import java.util.Set;

/**
 * Sensor message representative for Victim sensor.
 *
 * @author vejmanm
 */
public class SensorEncoder extends SuperSensor
{
    //public static final String type="Encoder";
    public static final SensorType type = SensorType.ENCODER_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorEncoder()
    {
        super(type);
    }

    /**
     * String is the sensor name. Integer is the tick count. Example:
     *
     * SEN {Type Encoder} {Name ECLeft Tick -61} {Name ECRight Tick -282} {Name
     * ECTilt Tick 0} {Name ECPan Tick 0}
     *
     * @param Name String representation of Tick.
     * @return Returns Tick value by input <b>Name</b>.
     */
    public int getTickByName(String Name)
    {
        return lastMessage.getEncoderTicks().get(Name);
    }

    /**
     * String is the sensor name. Integer is the tick count. Example:
     *
     * SEN {Type Encoder} {Name ECLeft Tick -61} {Name ECRight Tick -282} {Name
     * ECTilt Tick 0} {Name ECPan Tick 0}
     *
     * @return Returns KeySet representing the Encoder Tick names.
     */
    public Set<String> getEncoderNames()
    {
        return lastMessage.getEncoderTicks().keySet();
    }

    /**
     * Returns Encoder tick list size.
     *
     * @return Returns Encoder tick list size.
     */
    public int getEncodersSize()
    {
        return lastMessage.getEncoderTicks().size();
    }

    /**
     * String is the sensor name. Integer is the tick count. Example:
     *
     * SEN {Type Encoder} {Name ECLeft Tick -61} {Name ECRight Tick -282} {Name
     * ECTilt Tick 0} {Name ECPan Tick 0}
     *
     * @return Returns Map of Encoder couples String-Integers.
     */
    private Map<String, Integer> getEncoderTicks()
    {
        return lastMessage.getEncoderTicks();
    }
}
