package cz.cuni.amis.pogamut.usar2004.agent.module.nfo;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;

/**
 * Parent class for all possible nfo subjects. It covers the basic and common
 * properties for all the nfo subjects.
 *
 * @author vejmanm
 */
public abstract class SuperNfo extends SensorModule<USAR2004Bot>
{
    protected NfoMessageListener nfoListener;
    protected NfoMessage lastMessage;

    /**
     * Ctor.
     *
     * @param bot USAR2004Bot variable for filling base class.
     * @param type Nfo type describes particular subject about which
     * we want to know about. It is used to distinguish incoming message from
     * the server.
     */
    public SuperNfo(USAR2004Bot bot, String type)
    {
        super(bot);
        nfoListener = new NfoMessageListener(worldView, type);
    }

    @Override
    protected void cleanUp()
    {
        super.cleanUp();
        lastMessage = null;
    }

    /**
     * Used to make sure the object is filled.
     *
     * @return Returns true if the object is filled with Nfo message.
     */
    public Boolean isReady()
    {
        return (lastMessage != null);
    }

    private class NfoMessageListener implements IWorldEventListener<NfoMessage>
    {
        private String type = null;

        @Override
        public void notify(NfoMessage event)
        {
            if(isStartPoseMessage(event))
            {
                if(type.equalsIgnoreCase("StartPoses"))
                {
                    lastMessage = event;
                }
            }
            else
            {
                if(type.equalsIgnoreCase("MapInfo"))
                {
                    lastMessage = event;
                }
            }

//            switch(type)
//            {
//                case "MapInfo":
//                    if(!isStartPoseMessage(event))
//                        lastMessage = event;
//                    break;
//                case "StartPoses":
//                    if(isStartPoseMessage(event))
//                        lastMessage = event;
//                    break;
//            }
        }

        public NfoMessageListener(IWorldView worldView, String type)
        {
            this.type = type;
            worldView.addEventListener(NfoMessage.class, this);
        }

        /**
         * Check method for determination of the Nfo origin.
         *
         * @param new NfoMessage message.
         * @return Returns true if GameType is null or empty - Start Pose does
         * not have this property. False otherwise.
         */
        private boolean isStartPoseMessage(NfoMessage message)
        {
            if(message.getGameType() == null || "".equals(message.getGameType()))
            {
                return true;
            }
            return false;
        }
    }
}
