package cz.cuni.amis.pogamut.usar2004.agent.module.geometry;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.GeometryMessage;

/**
 * Parent class for all possible geometry subjects. It covers the basic and
 * common properties for all the geometry subjects.
 *
 * @author vejmanm
 */
public abstract class SuperGeometry
{
    protected GeometryMessage lastMessage;
    protected GeometryType geoType;

    /**
     * Ctor.
     *
     * @param type Geometry type describes particular subject about which we
     * want to know about. It is used to distinguish incoming message from the
     * server.
     */
    protected SuperGeometry(GeometryType type)
    {
        this.geoType = type;
    }

    /**
     * Used to make sure the object is filled.
     *
     * @return Returns true if the object is filled with Geo. message.
     */
    public Boolean isReady()
    {
        return (lastMessage != null);
    }

    /**
     * Type describes the vehicle type. It will be one of the following values:
     * "GroundVehicle”, “LeggedRobot”, “NauticVehicle”, or “AerialVehicle” of
     * "Camera" or some kind of sensor or effecter or "MisPkg".
     *
     * @return Returns type of the geometry message.
     */
    public String getType()
    {
        return lastMessage.getType();
    }

    /**
     * Name of the subject that this geometry message concerns.
     *
     * @return Returns the name of the Geometry item.
     */
    public String getName()
    {
        return lastMessage.getName();
    }

    /**
     * GeometryType is a descriptor used for creating particular instance and
     * for getting type information about particular configuration subject.
     *
     * @return Returns GeometryType.
     */
    public GeometryType getGeometryType()
    {
        return geoType;
    }

    /**
     * Method used for updating the message object that provides particular
     * properties for given type. Note that this object is created by yylex
     * parser and contains properties for all configuration subject types. But
     * only relevat to individual Geometry Subject are filled.
     *
     * @param message Geometry message from server.
     */
    public void updateMessage(GeometryMessage message)
    {
        //if(message.getType().equalsIgnoreCase(SensorType))
        lastMessage = message;
    }
}