package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Drive command specified for a ground vehicle with multiple omnidrive stearing.
 *
 * Corresponding GameBots command is DRIVE.
 *
 */
public class DriveOmni extends CommandMessage
{
    //constructor for the fifth type
    public DriveOmni(int WheelNumber, double WheelSpeed, double WheelSteer)
    {
        this.WheelNumbers.add(WheelNumber);
        this.WheelSpeeds.add(WheelSpeed);
        this.WheelSteers.add(WheelSteer);
    }
    //also constructor for the fifth type

    public DriveOmni(
            int[] WheelNumbers, double[] WheelSpeeds, double[] WheelSteers)
    {

        if((WheelNumbers.length == WheelSpeeds.length) && (WheelNumbers.length == WheelSteers.length))
        {
            for(int i = 0; i < WheelNumbers.length; i++)
            {
                this.WheelNumbers.add(WheelNumbers[i]);
                this.WheelSpeeds.add(WheelSpeeds[i]);
                this.WheelSteers.add(WheelSteers[i]);
            }
        }
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public DriveOmni()
    {
    }
    /////// Properties BEGIN
    //fifth type - WheelNumber..., WheelSpeed..., WheelSteer...
    // the number of an OmniDrive robot’s wheel as defined in the USARBot.ini. 
    protected List<Integer> WheelNumbers = new ArrayList<Integer>();

    public List<Integer> getWheelNumbers()
    {
        return WheelNumbers;
    }

    public void addWheelNumber(int number)
    {
        this.WheelNumbers.add(number);
    }

    public void addWheelNumber(int[] numbers)
    {
        for(int f : numbers)
        {
            this.WheelNumbers.add(f);
        }
    }
    //the spin speed, in rad/s, of the chosen wheel. 
    protected List<Double> WheelSpeeds = new ArrayList<Double>();

    public List<Double> getWheelSpeeds()
    {
        return WheelSpeeds;
    }

    public void addWheelSpeed(double speed)
    {
        this.WheelSpeeds.add(speed);
    }

    public void addWheelSpeed(double[] speeds)
    {
        for(double f : speeds)
        {
            this.WheelSpeeds.add(f);
        }
    }
    //the steer angle ,in rad, of the chosen wheel
    protected List<Double> WheelSteers = new ArrayList<Double>();

    public List<Double> getWheelSteers()
    {
        return WheelSteers;
    }

    public void addWheelSteer(double steer)
    {
        this.WheelSteers.add(steer);
    }

    public void addWheelSteer(double[] steers)
    {
        for(double f : steers)
        {
            this.WheelSteers.add(f);
        }
    }

    /*
     * Example: DRIVE {WheelNumber 0} {WheelSpeed 3.14} {WheelSteer 0.75}
     * {WheelNumber 1} {WheelSpeed -3.14} {WheelSteer 0.75} This command will
     * turn both wheels by 0.75 rad while giving them different velocities. If
     * you use the LISA robot setup, the robot rotates on place.
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public DriveOmni(DriveOmni original)
    {
        this.WheelNumbers.addAll(original.WheelNumbers);
        this.WheelSpeeds.addAll(original.WheelSpeeds);
        this.WheelSteers.addAll(original.WheelSteers);
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());

        buf.append("DRIVE");

        if((!WheelNumbers.isEmpty()) && (WheelNumbers.size() == WheelSpeeds.size()) && (WheelNumbers.size() == WheelSteers.size()))
        {
            for(int i = 0; i < WheelNumbers.size(); i++)
            {
                buf.append("<b>WheelNumber</b> : ").append(String.valueOf(WheelNumbers.get(i))).append(" <br/> ");

                buf.append("<b>WheelSpeed</b> : ").append(String.valueOf(WheelSpeeds.get(i))).append(" <br/> ");

                buf.append("<b>WheelSteer</b> : ").append(String.valueOf(WheelSteers.get(i))).append(" <br/> ");

            }
        }
        return buf.toString();
    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("DRIVE");

        if((!WheelNumbers.isEmpty()) && (WheelNumbers.size() == WheelSpeeds.size()) && (WheelNumbers.size() == WheelSteers.size()))
        {
            for(int i = 0; i < WheelNumbers.size(); i++)
            {
                buf.append(" {WheelNumber ").append(WheelNumbers.get(i)).append("}");
                buf.append(" {WheelSpeed ").append(WheelSpeeds.get(i)).append("}");
                buf.append(" {WheelSteer ").append(WheelSteers.get(i)).append("}");
            }
        }
        return buf.toString();
    }
}
