package cz.cuni.amis.pogamut.usar2004.agent.module.logic;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;


public class SyncUSAR2004BotLogic<BOT extends USAR2004Bot<? extends ILockableVisionWorldView, ?, ?>> extends USAR2004BotLogic<BOT> {



	//private ObjectEventReact<ConfigChange, ?> configChangeReaction;
	
	//private EventReact<EndMessage>        endReactionAfterRespawn;
	//private int						      shouldExecuteLogicLatch = 0;
	
	/*
         //not needed
         private ICommandListener<Respawn> respawnListener = new ICommandListener<Respawn>() {

		@Override
		public void notify(Respawn event) {			
			synchronized(respawnListener) {
				endReactionAfterRespawn.enable();
				shouldExecuteLogicLatch = 2;
			}
		}
		
	};*/
	
	@Inject
	public SyncUSAR2004BotLogic(BOT agent, IAgentLogic logic) {
		this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(agent.getWorldView()));
	}
	
	public SyncUSAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
		this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(agent.getWorldView()));
	}
	
	public SyncUSAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
		super(agent, logic, log, dependencies);
		/*
                 //USAR bots should not die
                 endReactionAfterRespawn = new EventReact<EndMessage>(EndMessage.class, agent.getWorldView()) {
			@Override
			protected void react(EndMessage event) {
				synchronized(respawnListener) {
					if (shouldExecuteLogicLatch > 0) {
						--shouldExecuteLogicLatch;
					}
				}
			}
		};*/
		//agent.getAct().addCommandListener(Respawn.class, respawnListener);
		
		/*
                 //it is not possible to change logic frequency at runtime in USARSim...
                 configChangeReaction = new ObjectEventReact<ConfigChange, IWorldObjectEvent<ConfigChange>>(ConfigChange.class, agent.getWorldView()) {
			@Override
			protected void react(IWorldObjectEvent<ConfigChange> event) {
				setLogicFrequency(1 / (Math.max(0.1, event.getObject().getVisionTime() - 0.02)));
			}
		};*/
                
	}
	
	@Override
	protected void beforeLogic(String threadName) {
		super.beforeLogic(threadName);
                //System.out.println("SyncUSAR2004BotLogic.beforeLogic()");

		if (log.isLoggable(Level.FINEST)) log.finest(threadName + ": Locking world view.");
		agent.getWorldView().lock();
		if (log.isLoggable(Level.FINER)) log.finer(threadName + ": World view locked.");
	}
	
	@Override
	protected void afterLogic(String threadName) {
		super.afterLogic(threadName);
                //System.out.println("SyncUSAR2004BotLogic.afterLogic()");

		if (log.isLoggable(Level.FINEST)) log.finest(threadName + ": Unlocking world view.");
		agent.getWorldView().unlock();
		if (log.isLoggable(Level.FINER)) log.finer(threadName + ": World view unlocked.");
	}
	
	@Override
	protected void afterLogicException(String threadName, Throwable e) {
		super.afterLogicException(threadName, e);

                //System.out.println("SyncUSAR2004BotLogic.afterLogicException()");
		if (agent.getWorldView().isLocked()) {
			if (log.isLoggable(Level.FINEST)) log.finest("Unlocking world view.");
			agent.getWorldView().unlock();
			if (log.isLoggable(Level.FINER)) log.finer("World view unlocked.");
		}
	}
	
	@Override
	protected boolean shouldExecuteLogic() {
            //System.out.println("SyncUSAR2004BotLogic.shouldExecuteLogic()");
            // in USARSim the robots should not die - although they can, but it is not supported by USAR messages.
            return true;
		/*synchronized(respawnListener) {
			if (shouldExecuteLogicLatch != 0) {
				if (log.isLoggable(Level.INFO)) log.info("Respawn command sensed - waiting for the bot respawn to execute logic with correct world view state.");
				return false;
			} else {
				return true;
			}
		}*/
	}
	
}
