package cz.cuni.amis.pogamut.usar2004.agent.module.datatypes;

import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.*;

/**
 * List of all Robot sensor Types. Each type can possibly represent more kinds
 * of sensor of same type. For each enum record, there exists relevant Class
 * which can be returned on demand.
 *
 * @author vejmanm
 */
public enum SensorType
{
    ENCODER_SENSOR(SensorEncoder.class, "Encoder"),
    ACCELERATION_SENSOR(SensorAcceleration.class, "Accel"),
    GPS_SENSOR(SensorGPS.class, "GPS"),
    HUMAN_MOTION_DETECTION(SensorHumanMotionDetector.class, "HumanMotion"),
    INS_SENSOR(SensorINS.class, "INS"),
    LASER_SENSOR(SensorLaser.class, "RangeScanner", "IRScanner"),
    ODOMETRY_SENSOR(SensorOdometry.class, "Odometry"),
    RFID_SENSOR(SensorRFID.class, "RFID"),
    RANGE_SENSOR(SensorRange.class, "Sonar", "IR"),
    SOUND_SENSOR(SensorSound.class, "Sound"),
    TACHOMETER(SensorTachometer.class, "Tachometer"),
    TOUCH_SENSOR(SensorTouch.class, "Touch"),
    VICTIM_SENSOR(SensorVictim.class, "VictSensor"),
    HELPER_SENSOR(SensorHelper.class, "Helper"),
    GROUND_TRUTH(SensorGroundTruth.class, "GroundTruth"),
    UNKNOWN_SENSOR(SuperSensor.class, "");
    private String[] kinds;
    private Class clazz;

    /**
     *
     * @param type - type of the sensor
     * @param clazz - class that carries data about this type of sensor
     */
    SensorType(Class clazz, String... kinds)
    {
        this.kinds = kinds;
        this.clazz = clazz;
    }

    /**
     * For each sensor type it chacks if <B>type</B> matches one of
     * <B>kinds</B>. If so, it returns relevant SensorType. Notice that this
     * method is static.
     *
     * @param type String representation or kind of Sensor
     * @return Returns relevant SensorType value to the String <B>type</B>
     */
    public static SensorType getType(String type)
    {
        for(SensorType senType : SensorType.values())
        {
            for(String kind : senType.kinds)
            {
                if(kind.equalsIgnoreCase(type))
                {
                    return senType;
                }
            }
        }
        return UNKNOWN_SENSOR;
    }

    /**
     * Notice that this method is not static.
     *
     * @return Returns class relevant to Actual SensorType
     */
    public Class getModuleClass()
    {
        return this.clazz;
    }
}
