/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

import math.geom2d.Point2D;

public class Obstacle1 {
    public static final double obstacleSize = 1.0;
    public static final double joinDistance = 1.5;
    public static final double maxExtendRatio = 4.0;
    public static final double maxEdgeSize = 5.0;
    private Point2D start;
    private Point2D stop;
    private int extendCount = 0;

    public Obstacle1(Point2D corner, double width, double height) {
        this.start = corner;
        this.stop = new Point2D(corner.x + width, corner.y + height);
    }

    public Obstacle1(Point2D start, Point2D stop) {
        this.start = start;
        this.stop = stop;
    }

    public Obstacle1(Point2D center) {
        this(center.x, center.y);
    }

    public Obstacle1(double centerX, double centerY) {
        this.start = new Point2D(centerX - 0.5, centerY - 0.5);
        this.stop = new Point2D(centerX + 0.5, centerY + 0.5);
    }

    private boolean extend(double x, double y) {
        boolean success = false;
        if (x + 0.5 > this.stop.x) {
            this.stop.x = x + 0.5;
            success = true;
        }
        if (y + 0.5 > this.stop.y) {
            this.stop.y = y + 0.5;
            success = true;
        }
        if (x - 0.5 < this.start.x) {
            this.start.x = x - 0.5;
            success = true;
        }
        if (y - 0.5 < this.start.y) {
            this.start.y = y - 0.5;
            success = true;
        }
        return success;
    }

    public double getWidth() {
        return this.stop.x - this.start.x;
    }

    public double getHeight() {
        return this.stop.y - this.start.y;
    }

    public Point2D getCorner() {
        return this.start;
    }

    public Obstacle1 tryExtend(double x, double y) {
        if (x > this.start.x - 1.5 && x < this.stop.x + 1.5 && y > this.start.y - 1.5 && y < this.stop.y + 1.5) {
            if (this.extend(x, y)) {
                ++this.extendCount;
            }
            return this;
        }
        return null;
    }

    public boolean canExtend() {
        return this.extendCount < 3;
    }

    public boolean isInside(double x, double y) {
        return x > this.start.x && x < this.stop.x && y > this.start.y && y < this.stop.y;
    }

    public boolean isWithin(double x, double y) {
        return x > this.start.x - 0.5 && x < this.stop.x + 0.5 && y > this.start.y - 0.5 && y < this.stop.y + 0.5;
    }

    public static Obstacle1 MergeObstacles(Obstacle1 blockA, Obstacle1 blockB) {
        double xA = blockA.start.x;
        double xB = blockB.start.x;
        double yA = blockA.start.y;
        double yB = blockB.start.y;
        double xC = blockA.start.x;
        double yC = blockA.start.y;
        double xD = blockB.stop.x;
        double yD = blockB.stop.y;
        Point2D newStart = new Point2D(Math.min(xA, xB), Math.min(yA, yB));
        Point2D newStop = new Point2D(Math.min(xC, xD), Math.min(yC, yD));
        return new Obstacle1(newStart, newStop);
    }
}

