package cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.event.*;
import cz.cuni.amis.pogamut.base.communication.translator.event.*;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.usar2004.communication.messages.GBEvent;

/**
 *
 * This bot has died.
 *
 * Corresponding GameBots message is DIE.
 *
 */
public class KillMessage extends GBEvent implements IWorldEvent, IWorldChangeEvent
{
    /**
     * Creates new instance of command KillMessage.
     *
     * @param Killer Unique Id of player that killed our bot if any (may have
     * walked off a ledge).
     *
     * @param DamageType A string describing what kind of damage killed the bot.
     * @param DeathString String describing this type of death.
     * @param WeaponName Name of the weapon that caused this damage.
     * @param Flaming If this damage is causing our bot to burn. TODO
     * @param CausedByWorld If this damage was caused by world - falling into
     * lava, or falling down.
     * @param DirectDamage If the damage is direct. TODO
     * @param BulletHit If this damage was caused by bullet.
     * @param VehicleHit If this damage was caused by vehicle running over us.
     *
     */
    public KillMessage(UnrealId Killer, String DamageType, String DeathString, String WeaponName, boolean Flaming, boolean CausedByWorld, boolean DirectDamage, boolean BulletHit, boolean VehicleHit)
    {
        this.Killer = Killer;
        this.DamageType = DamageType;
        this.DeathString = DeathString;
        this.WeaponName = WeaponName;
        this.Flaming = Flaming;
        this.CausedByWorld = CausedByWorld;
        this.DirectDamage = DirectDamage;
        this.BulletHit = BulletHit;
        this.VehicleHit = VehicleHit;
    }
    /**
     * Example how the message looks like - used during parser tests.
     */
    public static final String PROTOTYPE = "DIE {Killer unreal_id} {DamageType text} {DeathString text} {WeaponName text} {Flaming False} {CausedByWorld False} {DirectDamage False} {BulletHit False} {VehicleHit False}";
    /////// Properties BEGIN
    /**
     *
     * Unique Id of player that killed our bot if any (may have walked off a
     * ledge).
     */
    protected UnrealId Killer =
            null;

    /**
     *
     * Unique Id of player that killed our bot if any (may have walked off a
     * ledge).
     */
    public UnrealId getKiller()
    {
        return Killer;
    }
    /**
     *
     * A string describing what kind of damage killed the bot.
     */
    protected String DamageType =
            null;

    /**
     *
     * A string describing what kind of damage killed the bot.
     */
    public String getDamageType()
    {
        return DamageType;
    }
    /**
     *
     * String describing this type of death.
     */
    protected String DeathString =
            null;

    /**
     *
     * String describing this type of death.
     */
    public String getDeathString()
    {
        return DeathString;
    }
    /**
     *
     * Name of the weapon that caused this damage.
     */
    protected String WeaponName =
            null;

    /**
     *
     * Name of the weapon that caused this damage.
     */
    public String getWeaponName()
    {
        return WeaponName;
    }
    /**
     *
     * If this damage is causing our bot to burn. TODO
     */
    protected boolean Flaming =
            false;

    /**
     *
     * If this damage is causing our bot to burn. TODO
     */
    public boolean isFlaming()
    {
        return Flaming;
    }
    /**
     *
     * If this damage was caused by world - falling into lava, or falling down.
     */
    protected boolean CausedByWorld =
            false;

    /**
     *
     * If this damage was caused by world - falling into lava, or falling down.
     */
    public boolean isCausedByWorld()
    {
        return CausedByWorld;
    }
    /**
     *
     * If the damage is direct. TODO
     */
    protected boolean DirectDamage =
            false;

    /**
     *
     * If the damage is direct. TODO
     */
    public boolean isDirectDamage()
    {
        return DirectDamage;
    }
    /**
     *
     * If this damage was caused by bullet.
     */
    protected boolean BulletHit =
            false;

    /**
     *
     * If this damage was caused by bullet.
     */
    public boolean isBulletHit()
    {
        return BulletHit;
    }
    /**
     *
     * If this damage was caused by vehicle running over us.
     */
    protected boolean VehicleHit =
            false;

    /**
     *
     * If this damage was caused by vehicle running over us.
     */
    public boolean isVehicleHit()
    {
        return VehicleHit;
    }

    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    public long getSimTime()
    {
        // NOT IMPLEMENTED FOR UDK
        return 0;
    }

    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public KillMessage(KillMessage original)
    {
        this.Killer = original.Killer;
        this.DamageType = original.DamageType;
        this.DeathString = original.DeathString;
        this.WeaponName = original.WeaponName;
        this.Flaming = original.Flaming;
        this.CausedByWorld = original.CausedByWorld;
        this.DirectDamage = original.DirectDamage;
        this.BulletHit = original.BulletHit;
        this.VehicleHit = original.VehicleHit;
    }

    /**
     * Used by Yylex to create empty message then to fill it's protected fields
     * (Yylex is in the same package).
     */
    public KillMessage()
    {
    }

    @Override
    public String toString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString() + " | "
                + "Killer = "
                + String.valueOf(Killer) + " | "
                + "DamageType = "
                + String.valueOf(DamageType) + " | "
                + "DeathString = "
                + String.valueOf(DeathString) + " | "
                + "WeaponName = "
                + String.valueOf(WeaponName) + " | "
                + "Flaming = "
                + String.valueOf(Flaming) + " | "
                + "CausedByWorld = "
                + String.valueOf(CausedByWorld) + " | "
                + "DirectDamage = "
                + String.valueOf(DirectDamage) + " | "
                + "BulletHit = "
                + String.valueOf(BulletHit) + " | "
                + "VehicleHit = "
                + String.valueOf(VehicleHit) + " | "
                + "");
        return buf.toString();

    }

    /**
     * Gets all properties and values to create a HTML formated string;
     *
     * @return Returns all properties in HTML format
     */
    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()
                + "<b>Killer</b> : "
                + String.valueOf(Killer)
                + " <br/> "
                + "<b>DamageType</b> : "
                + String.valueOf(DamageType)
                + " <br/> "
                + "<b>DeathString</b> : "
                + String.valueOf(DeathString)
                + " <br/> "
                + "<b>WeaponName</b> : "
                + String.valueOf(WeaponName)
                + " <br/> "
                + "<b>Flaming</b> : "
                + String.valueOf(Flaming)
                + " <br/> "
                + "<b>CausedByWorld</b> : "
                + String.valueOf(CausedByWorld)
                + " <br/> "
                + "<b>DirectDamage</b> : "
                + String.valueOf(DirectDamage)
                + " <br/> "
                + "<b>BulletHit</b> : "
                + String.valueOf(BulletHit)
                + " <br/> "
                + "<b>VehicleHit</b> : "
                + String.valueOf(VehicleHit)
                + " <br/> "
                + "");
        return buf.toString();
    }
}
