package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

/**
 * ‘int’, ’double’, ’char’ provide the latitude degree, minute (as a decimal),
 * and cardinal description (i.e. ‘N’ or ‘S’), respectively. There are only two
 * possible values for the ‘char’ parameter: ‘N’ for North and ‘S’ for South.
 *
 * This class is used to store data from GPS sensor.
 *
 * @author vejmanm
 */
public class Latitude extends GeographicCoordinates
{
    public Latitude()
    {
    }

    public Latitude(int degree, double minute, char cardinal)
    {
        super(degree, minute, cardinal);
    }

    /**
     * Converter method for converting the degree, minute to minutes
     * respectively to cardinal character.
     *
     * @param latitude Latitude to convert
     * @return Returns minute representation of input latitude.
     */
    public static double DMCToMinutes(Latitude latitude)
    {
        double returnee = latitude.minute + latitude.degree * 60;
        return (latitude.cardinal == 'S')?-returnee:returnee;
    }

    /**
     * Converter method for converting minutes to degree minutes and to
     * determine cardinal character.
     *
     * @param minutes Minute representation of Latitude
     * @return Returns latitude representation of input minutes.
     */
    public static Latitude MinutesTODMC(double minutes)
    {
        double minute = Math.abs(minutes % 60);
        int degree = Math.abs((int) minutes / 60);
        char cardinal = (minutes < 0)?'S':'N';
        return new Latitude(degree, minute, cardinal);
    }

    /**
     * Converter method for converting the degree, minute to degrees
     * respectively to cardinal character.
     *
     * @param latitude Latitude to convert
     * @return Returns degree representation of input latitude.
     */
    public static double DMCToDegree(Latitude latitude)
    {
        double returnee = latitude.minute / 60d + latitude.degree;
        return (latitude.getCardinal() == 'S')?-returnee:returnee;
    }

    /**
     * Converter method for converting degrees to degree minutes and to
     * determine cardinal character.
     *
     * @param degree Degree representation of Latitude
     * @return Returns latitude representation of input degrees.
     */
    public static Latitude DegreeToDMC(double degree)
    {
        int deg = (int) Math.abs(degree);
        double minute = (Math.abs(degree) - deg) * 60;
        char cardinal = (degree < 0)?'S':'N';
        return new Latitude(deg, minute, cardinal);
    }
}
