package cz.cuni.amis.pogamut.usar2004.agent;

import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;

public interface IUSAR2004BotController<BOT extends USAR2004Bot> {

    /**
     * Called during the construction of the {@link UT2004Bot} before the GameBots2004 greets the bot even before
     * {@link IUT2004BotController#prepareBot(UT2004Bot)} method.
     * <p><p>
     * <b>NOTE:</b> This is Pogamut's developers reserved method - do not override it and if you do, always use 'super'
     * to call parent's initializeController.
     */
    public void initializeController(BOT bot);

    /**
     * Called during the construction of the {@link UT2004Bot} before the GameBots2004 greets the bot.
     */
    public void prepareBot(BOT bot);

    /**
     * Called when first NFO message arrives.
     */
    public void robotInitialized(NfoMessage nfoMessage);
}
