package cz.cuni.amis.pogamut.usar2004.agent.module.state;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.StateMessage;

/**
 * Parent class for all possible state subjects. It covers the basic and common
 * properties for all the state subjects.
 *
 * @author vejmanm
 */
public /*
         * abstract
         */ class SuperState
{
    protected StateMessage lastMessage;
    protected VehicleType vehicleType;

    /**
     * Ctor. State type describes particular subject about which we want to know
     * about. It is used to distinguish incoming message from the server.
     */
    public SuperState()
    {
        this(VehicleType.UNKNOWN);
    }

    /**
     * Ctor.
     *
     * @param type Configuration type describes particular subject about which
     * we want to know about. It is used to distinguish incoming message from
     * the server.
     */
    protected SuperState(VehicleType type)
    {
        this.vehicleType = type;
    }

//    @Override
//    protected void cleanUp()
//    {
//        super.cleanUp();
//        bot=null;
//        lastMessage = null;
//        sensorType=null;
//    }
    /**
     * Method used for updating the message object that provides particular
     * properties for given type. Note that this object is created by yylex
     * parser and contains properties for all configuration subject types. But
     * only relevat to individual Config Subject are filled.
     *
     * @param message State message from server.
     */
    public void updateMessage(StateMessage message)
    {
        //if(message.getType().equalsIgnoreCase(SensorType))
        lastMessage = message;
    }

    /**
     * Timestamp form the UT since server start in seconds.
     *
     * @return Returns seconds elapsed from the start of the server.
     */
    public double getTime()
    {
        return lastMessage.getTime();
    }

    /**
     * Used to make sure the object is filled.
     *
     * @return Returns true if the object is filled with State message.
     */
    public Boolean isReady()
    {
        return (lastMessage != null);
    }

    /**
     * Type will be one of the following values: "GroundVehicle”, “LeggedRobot”,
     * “NauticVehicle”, or “AerialVehicle”.
     *
     * @return Returns Type of the vehicle.
     */
    public String getType()
    {
        return lastMessage.getType();
    }

    /**
     * Power state of the battery. It is the battery lifetime in second. It’s
     * the total time remaining for the robot to run.
     *
     * @return Returns remaining battery life.
     */
    public int getBattery()
    {
        return lastMessage.getBattery();
    }

    /**
     * Light intensity of the headlight. Right now, it always is 100.
     *
     * @return Returns the intensity of the Headlight.
     */
    public int getFlashLightIntensity()
    {
        return lastMessage.getLightIntensity();
    }

    /**
     * Indicate whether the headlight has been turned on.
     *
     * @return Returns wether the Headlight is on or not.
     */
    public boolean isFlashLightToogle()
    {
        return lastMessage.isLightToggle();
    }

    /**
     * VehicleType is a descriptor used for creating particular instance and for
     * getting type information about particular state subject.
     *
     * @return Returns VehicleType.
     */
    public VehicleType getVehicleType()
    {
        return vehicleType;
    }
}