package cz.cuni.amis.pogamut.usar2004.agent.module.response;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ResponseType;

/**
 * response message recieved after SET {Type Sensor} or SET {Type Effector}
 * command where Sensor and Effector are names of robots device.
 *
 * @author vejmanm
 */
public class ResponseSensorEffecter extends SuperResponse
{
    public static final ResponseType type = ResponseType.SENSOR_EFFECTER;

    /**
     * Ctor. Response type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public ResponseSensorEffecter()
    {
        super(type);
    }

    /**
     * Returns name of the sensor or effecter.
     *
     * @return Returns name of the sensor or effecter.
     */
    public String getName()
    {
        return lastMessage.getNames().get(0);
    }

    /**
     *
     * Returns status of the sensor or effecter operation.
     *
     * @return Returns status of the sensor or effecter operation.
     */
    public String getStatus()
    {
        return lastMessage.getStatuses().get(0);
    }
}
