package cz.cuni.amis.pogamut.usar2004.agent.module.datatypes;

import cz.cuni.amis.pogamut.usar2004.agent.module.response.*;

/**
 * List of all Robot Response Types. Each type can represent only one kind of
 * Response type. For each enum record, there exists relevant Class which can be
 * returned on demand.
 *
 * @author vejmanm
 */
public enum ResponseType
{
    CAMERA(ResponseCamera.class, "Camera"),
    VIEWPORT(Viewport.class, "Viewports"),
    SENSOR_EFFECTER(ResponseSensorEffecter.class, "");
    private String kind;
    private Class clazz;

    /**
     *
     * @param type - type of the Response message
     * @param clazz - class that carries data about this type of the response
     */
    ResponseType(Class clazz, String kind)
    {
        this.kind = kind;
        this.clazz = clazz;
    }

    /**
     * For each Response type it checks if <B>type</B> matches one of
     * <B>kinds</B>. If so, it returns relevant ResponseType. Notice that this
     * method is static. If nothing matches, it returns SENSOR_EFFECTER
     *
     * @param type String representation or kind of Response
     * @return Returns relevant ResponseType value to the String <B>type</B>
     */
    public static ResponseType getType(String type)
    {
        for(ResponseType resType : ResponseType.values())
        {
            if(resType.kind.equalsIgnoreCase(type))
            {
                return resType;
            }
        }
        return SENSOR_EFFECTER;
    }

    /**
     * Notice that this method is not static.
     *
     * @return Returns class relevant to Actual ResponseType
     */
    public Class getModuleClass()
    {
        return this.clazz;
    }
}
