/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.agent.module.master;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryContainer;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.MessageDescriptor;
import cz.cuni.amis.pogamut.usar2004.agent.module.geometry.SuperGeometry;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ModuleInstanceProvider;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.GetGeo;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.GeometryMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeometryMasterModule
extends SensomotoricModule<USAR2004Bot> {
    protected GeometryMessageListener geoListener;
    protected static GeometryMasterModule singleton = null;
    protected GeometryContainer geometryModules = new GeometryContainer();

    private GeometryMasterModule(USAR2004Bot bot) {
        super((IEmbodiedAgent)bot);
        this.geoListener = new GeometryMessageListener(this.worldView);
    }

    public static GeometryMasterModule getModuleInstance(USAR2004Bot bot) {
        if (singleton == null) {
            singleton = new GeometryMasterModule(bot);
        }
        return singleton;
    }

    public Boolean isReady() {
        return this.geometryModules != null && !this.geometryModules.isEmpty();
    }

    public List<SuperGeometry> getGeometriesByClass(Class clazz) {
        return this.geometryModules.getGeometriesByClass(clazz);
    }

    public List<SuperGeometry> getGeometriesByType(String type) {
        if (type == null) {
            return null;
        }
        return this.geometryModules.getGeometriesByType(type.toLowerCase());
    }

    public List<SuperGeometry> getGeometriesByGeometryType(GeometryType type) {
        return this.geometryModules.getGeometriesByGeometryType(type);
    }

    public SuperGeometry getGeometryByTypeName(String type, String name) {
        if (type == null || name == null) {
            return null;
        }
        return this.geometryModules.getGeometryByTypeName(type.toLowerCase(), name.toLowerCase());
    }

    public List<MessageDescriptor> getNonEmptyDescription() {
        return this.geometryModules.getNonEmptyDescription();
    }

    public void queryGeometryByType(String type) {
        this.queryGeometryByTypeName(type, null);
    }

    public void queryGeometryByTypeName(String type, String name) {
        this.act.act((CommandMessage)new GetGeo(type, name));
    }

    protected SuperGeometry createNewSensor(GeometryMessage message) {
        return ModuleInstanceProvider.getGeometryInstanceByType(message.getType());
    }

    protected boolean updateSensorCollection(GeometryMessage message) {
        if (!this.geometryModules.containsKey(message.getType().toLowerCase())) {
            return false;
        }
        if (((Map)this.geometryModules.get(message.getType().toLowerCase())).isEmpty()) {
            return false;
        }
        return ((Map)this.geometryModules.get(message.getType().toLowerCase())).containsKey(message.getName().toLowerCase());
    }

    protected void fileMessage(GeometryMessage message) {
        if (this.updateSensorCollection(message)) {
            return;
        }
        if (!this.geometryModules.containsKey(message.getType().toLowerCase())) {
            this.geometryModules.put(message.getType().toLowerCase(), new HashMap());
        }
        if (((Map)this.geometryModules.get(message.getType().toLowerCase())).isEmpty() || !((Map)this.geometryModules.get(message.getType().toLowerCase())).containsKey(message.getName().toLowerCase())) {
            SuperGeometry newSensor = this.createNewSensor(message);
            if (newSensor == null) {
                System.out.println("This geometry message is not supported! " + message.getName());
                return;
            }
            String type = message.getType().toLowerCase();
            String name = message.getName().toLowerCase();
            newSensor.updateMessage(message);
            ((Map)this.geometryModules.get(type)).put(name, newSensor);
        }
    }

    protected void cleanUp() {
        super.cleanUp();
        this.geoListener = null;
        this.geometryModules = null;
        singleton = null;
    }

    private class GeometryMessageListener
    implements IWorldEventListener<GeometryMessage> {
        public void notify(GeometryMessage event) {
            GeometryMasterModule.this.fileMessage(event);
        }

        public GeometryMessageListener(IWorldView worldView) {
            worldView.addEventListener(GeometryMessage.class, (IWorldEventListener)this);
        }
    }
}

