package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.TraceColor;

/**
 *
 * USARSim has the capability of tracing the path that a robot takes. Colored
 * Navigation Points are dropped into the world as the robot travels;
 * effectively “tracing” the robot’s path. Tracing can be used with the *
 * Corresponding GameBots command is Trace.
 *
 */
public class Trace extends CommandMessage
{
    public Trace(boolean On, double Interval, TraceColor Color)
    {
        this.On = On;
        this.Interval = Interval;
        this.Color = Color.getName();
    }

    public Trace(boolean On, double Interval, String Color)
    {
        this.On = On;
        this.Interval = Interval;
        this.Color = Color;
    }

    public Trace(String Clear)
    {
        this.Clear = Clear;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public Trace()
    {
    }
    /////// Properties BEGIN
    //tells USARSim to start/stop tracing the robot’s path. Default value is false. 
    protected boolean On = false;

    public boolean isOn()
    {
        return On;
    }

    public Trace setOn(boolean On)
    {
        this.On = On;
        return this;
    }
    /*
     * is a number that dictates how many seconds will go by before USARSim
     * drops a Navigation Point. Please note that this number is in unreal units
     * and that its default value is 0.
     */
    protected double Interval = 0;

    public double getInterval()
    {
        return Interval;
    }

    public Trace setInterval(double Interval)
    {
        this.Interval = Interval;
        return this;
    }
    /*
     * The value for this parameter can be entered as an int or a string. It
     * determines the color of the trace as follows: ‘0’ or ‘Red’ – Red Trace
     * [DEFAULT] ‘1’ or ‘Yellow’ – Yellow Trace ‘2’ or ‘Green’ – Green Trace ‘3’
     * or ‘Cyan’ – Cyan Trace ‘4’ or ‘White’ – White Trace ‘5’ or ‘Blue’ – Blue
     * Trace ‘6’ or ‘Purple’ – Purple Trace
     */
    protected String Color = null;

    public String getColor()
    {
        return Color;
    }

    public Trace setColor(String Color)
    {
        this.Color = Color;
        return this;
    }
    protected String Clear = null;

    public String getClear()
    {
        return Clear;
    }

    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public Trace(Trace original)
    {
        this.On = original.On;
        this.Interval = original.Interval;
        this.Color = original.Color;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>On</b> : "
                + String.valueOf(On)
                + " <br/> "
                + "<b>Interval</b> : "
                + String.valueOf(Interval)
                + " <br/> "
                + "<b>Color</b> : "
                + String.valueOf(Color)
                + " <br/> "
                + "<b>Clear</b> : "
                + String.valueOf(Clear)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();

        buf.append("Trace");

        if(Clear != null)
        {
            //We dont want to say that trace is of, we just want to send "trace {clear ROBOT}" message without any other confusing parameters
            buf.append(" {Clear ").append(Clear).append("}");
            return buf.toString();
        }

        buf.append(" {On ").append(On).append("}");
        buf.append(" {Interval ").append(Interval).append("}");

        if(Color != null)
        {
            buf.append(" {Color ").append(Color).append("}");
        }


        return buf.toString();
    }
}
