package cz.cuni.amis.pogamut.usar2004.agent.module.state;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;

/**
 * State message representative for Nautic vehicle.
 * @author vejmanm
 */
public class StateNautic extends SuperState
{
    public static final VehicleType type = VehicleType.NAUTIC_VEHICLE;

    /**
     * Ctor. State type describes particular subject about which we want to know
     * about. It is used to distinguish incoming message from the server.
     */
    public StateNautic()
    {
        super(type);
    }

    /**
     * Note: parameter only available for robots of “NauticVehicle” type.
     * Current rudder angle of the robot, in radians.
     *
     * @return Returns rudder angle.
     */
    public double getRudderAngle()
    {
        return lastMessage.getRudderAngle();
    }

    /**
     * Note: parameter only available for robots of “GroundVehicle” type.
     * Current rear steer angle of the robot, in radians.
     *
     * @return Returns rear steer angle value.
     */
    public double getRudderSteer()
    {
        return lastMessage.getRearSteer();
    }
}
