package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;

/**
 *
 * Sensor message representative for RFID sensor.
 *
 * @author vejmanm
 */
public class SensorRFID extends SuperSensor
{
    //public static final String type="RFID";
    public static final SensorType type = SensorType.RFID_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorRFID()
    {
        super(type);
    }

    /**
     * Used by RFID sensor. RFID tags are simulated by implementing the class
     * USARBot.RFIDTag class in the Unreal Editor when editing a map. This class
     * contains an integer id and a boolean bSingleshot variable that determines
     * whether the tag is a single shot tag or a multi shot tag. They are
     * deployed by placing them in UnrealEd. If the tag’s id is set to -1 (the
     * default), then the tag id will be set to a unique value automatically.
     * Other values for the id will not be changed. If the tags are within the
     * MaxRange of the RFID sensor mounted on the robot then the server sends
     * the following message to the client:
     *
     * @param index
     * @return Returns RFID ID at given index..
     */
    public int getIDAt(int index)
    {
        if(index < getIDSize())
        {
            return lastMessage.getIDs().get(index);
        }
        else
        {
            return -1;
        }
    }

    /**
     * List of Locations used by RFID sensor to determine where are various RFID
     * Tags or by Victiom sensor to determine locations of bodys. Also used by
     * INS sensor to determine robots location
     *
     * @param index
     * @return Returns Location at given index.
     */
    public Location getLocationAt(int index)
    {
        if(index < getLocationsSize())
        {
            return lastMessage.getLocations().get(index);
        }
        else
        {
            return null;
        }
    }

    /**
     * Returns size of RFID IDs list.
     *
     * @return Returns size of RFID IDs list.
     */
    public int getIDSize()
    {
        return lastMessage.getIDs().size();
    }

    /**
     * Returns Location list size.
     *
     * @return Returns Location list size.
     */
    public int getLocationsSize()
    {
        return lastMessage.getLocations().size();
    }
}
