package cz.cuni.amis.pogamut.usar2004.agent.module.configuration;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ConfigType;

/**
 * Configuration message representative for Ground vehicles.
 *
 * @author vejmanm
 */
public class ConfigGround extends VehicleConfiguration
{
    public static final ConfigType type = ConfigType.GROUND_VEHICLE;

    /**
     * Ctor. Configuration type describes particular subject about which we want
     * to know about. It is used to distinguish incoming message from the
     * server.
     */
    public ConfigGround()
    {
        super(type);
    }

    /**
     * Returned value represents maximum speed, in rad/s.
     *
     * @return Returns maximum speed of the robot.
     */
    public double getMaxSpeed()
    {
        return lastMessage.getMaxSpeeds().get(0);
    }

    /**
     * Returned value represents maximum torque.
     *
     * @return Returns maximum torque value of the robots drive.
     */
    public double getMaxTorque()
    {
        return lastMessage.getMaxTorques().get(0);
    }

    /**
     * The maximum steering angle for robot’s front wheels, in radians. Please
     * note that this value will be 0 for skid steered vehicles.
     *
     * @return Returns maximum front steer.
     */
    public double getMaxFrontSteer()
    {
        return lastMessage.getMaxFrontSteer();
    }

    /**
     * The maximum steering angle for robot’s rear wheels, in radians. Please
     * note that this value will be 0 for skid steered vehicles.
     *
     * @return Returns maximum rear steer.
     */
    public double getMaxRearSteer()
    {
        return lastMessage.getMaxRearSteer();
    }
}
