/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.samples;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogicController;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.SensorMessage;
import cz.cuni.amis.pogamut.usar2004.utils.USAR2004BotRunner;
import java.util.ArrayList;
import java.util.logging.Level;

@AgentScoped
public class P2DXLogicController
extends USAR2004BotLogicController {
    private USAR2004BotLogicController log;
    IWorldEventListener<SensorMessage> sensorList = new IWorldEventListener<SensorMessage>(){

        public void notify(SensorMessage t) {
            if (t.getLaserRanges().size() > 1) {
                ArrayList<Double> f = new ArrayList<Double>();
                f.addAll(t.getLaserRanges());
                P2DXLogicController.this.RangesReady(f);
            }
        }
    };
    int left = 0;
    int right = 0;
    private int step = 20;
    boolean reversActive = false;

    @Override
    public void robotInitialized(NfoMessage nfom) {
        this.getAct().act((CommandMessage)new Initialize("USARBot.P2DX", "P2DX - logic controller", nfom.getStartPoses().get(0).getName()));
    }

    @Override
    public void initializeController(USAR2004Bot bot) {
        super.initializeController(bot);
    }

    @Override
    public void prepareBot(USAR2004Bot bot) {
        super.prepareBot(bot);
        this.log = new USAR2004BotLogicController();
        this.getWorldView().addEventListener(SensorMessage.class, this.sensorList);
    }

    @Override
    public void logic() {
        System.out.println("P2DXLogicController.logic()");
        this.getAct().act((CommandMessage)new DriveSkid(this.left, this.right, false, false, false));
    }

    private void driveLeft() {
        this.right = 15;
        this.left = 5;
    }

    private void driveRight() {
        this.right = 4;
        this.left = 15;
    }

    private void driveStraight() {
        this.right = 15;
        this.left = 15;
    }

    private void driveBackwards() {
        if (this.step > 10) {
            this.right = -3;
            this.left = -3;
        } else {
            this.right = -3;
            this.left = 3;
        }
        --this.step;
        if (this.step == 0) {
            this.step = 20;
            this.reversActive = false;
        }
    }

    public void RangesReady(ArrayList<Double> Ranges) {
        int third = Ranges.size() / 3;
        double mleft = 0.0;
        double mright = 0.0;
        double mstraight = 0.0;
        int i = 0;
        while (i < Ranges.size()) {
            if (i < third) {
                mright += Ranges.get(i).doubleValue();
            } else if (i < 2 * third) {
                mstraight += Ranges.get(i).doubleValue();
            } else {
                mleft += Ranges.get(i).doubleValue();
            }
            ++i;
        }
        if (this.reversActive || mleft + mstraight < 200.0 || mright + mstraight < 200.0) {
            this.reversActive = true;
            this.driveBackwards();
        } else if (Math.max(mleft, mright) == mleft) {
            if (Math.max(mleft, mstraight) == mleft) {
                this.driveLeft();
            } else {
                this.driveStraight();
            }
        } else if (Math.max(mright, mstraight) == mright) {
            this.driveRight();
        } else {
            this.driveStraight();
        }
    }

    public static void main(String[] args) {
        new USAR2004BotRunner(P2DXLogicController.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.WARNING).startAgent();
    }
}

