/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ClosestObstacle;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.DriveDirection;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SuperSensor;
import java.util.List;

public class SensorLaser
extends SuperSensor {
    public static final SensorType type = SensorType.LASER_SENSOR;

    public SensorLaser() {
        super(type);
    }

    private double sumList(List<Double> list, int from, int to) {
        double sum = 0.0;
        int i = from;
        while (i < to) {
            sum += list.get(i).doubleValue();
            ++i;
        }
        return sum;
    }

    public ClosestObstacle getClosestObstacleCourse() {
        double mright;
        int half;
        List<Double> Ranges = this.lastMessage.getLaserRanges();
        double mleft = this.sumList(Ranges, 0, half = Ranges.size() / 2);
        if (mleft < (mright = this.sumList(Ranges, half, Ranges.size()))) {
            return ClosestObstacle.LEFT;
        }
        return ClosestObstacle.RIGHT;
    }

    public double getClosestObstacleDistance() {
        List<Double> Ranges = this.lastMessage.getLaserRanges();
        double closest = Double.MAX_VALUE;
        for (Double double1 : Ranges) {
            if (!(closest > double1)) continue;
            closest = double1;
        }
        return closest;
    }

    public DriveDirection getMostOpenDirection(int backwardsTreshold) {
        List<Double> Ranges = this.lastMessage.getLaserRanges();
        int third = Ranges.size() / 3;
        double mright = this.sumList(Ranges, 0, third - 10);
        double mstraight = this.sumList(Ranges, third + 10, 2 * (third - 10));
        double mleft = this.sumList(Ranges, 2 * (third + 10), Ranges.size());
        if (mleft + mstraight < (double)backwardsTreshold || mright + mstraight < (double)backwardsTreshold || mstraight < (double)(backwardsTreshold / 4)) {
            return DriveDirection.BACKWARD;
        }
        if (mstraight > 400.0) {
            return DriveDirection.FORWARD;
        }
        if (mleft >= mright && mleft >= mstraight) {
            return DriveDirection.LEFT;
        }
        if (mright >= mleft && mright >= mstraight) {
            return DriveDirection.RIGHT;
        }
        return DriveDirection.FORWARD;
    }

    public double getResolution() {
        return this.lastMessage.getResolution();
    }

    public double getFOV() {
        return this.lastMessage.getFOV();
    }

    public double getRangeAt(int index) {
        if (index < this.getRangesSize()) {
            return this.getRanges().get(index);
        }
        return -1.0;
    }

    public int getRangesSize() {
        return this.lastMessage.getLaserRanges().size();
    }

    public List<Double> getRanges() {
        return this.lastMessage.getLaserRanges();
    }

    public double getNMidAvg(int numOfRays) {
        return this.getNMidAvg(numOfRays, 0);
    }

    public double getNMidAvg(int numOfRays, int offset) {
        if (numOfRays >= this.getRangesSize()) {
            numOfRays = this.getRangesSize();
        }
        double avg = 0.0;
        int from = this.getRangesSize() / 2 - numOfRays / 2 + offset;
        int to = this.getRangesSize() / 2 - numOfRays / 2 + numOfRays + offset;
        if (from < 0) {
            to -= 0 - from;
            from = 0;
        } else if (to > this.getRangesSize()) {
            from -= to - this.getRangesSize();
            to = this.getRangesSize();
        }
        int i = from;
        while (i < to) {
            avg += this.getRangeAt(i);
            ++i;
        }
        return avg / (double)numOfRays;
    }
}

