/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.communication.translator.bot.state;

import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointListEnd;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointListStart;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointNeighbourLinkEnd;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointNeighbourLinkStart;
import cz.cuni.amis.pogamut.udk.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.udk.communication.translator.TranslatorMessages;
import cz.cuni.amis.pogamut.udk.communication.translator.UnexpectedMessageException;
import cz.cuni.amis.pogamut.udk.communication.translator.bot.state.HandshakeControllerState;
import cz.cuni.amis.pogamut.udk.communication.translator.bot.state.NavPointNeighboursState;
import cz.cuni.amis.pogamut.udk.communication.translator.bot.support.AbstractBotFSMState;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FSMState(map={@FSMTransition(state=HandshakeControllerState.class, symbol={NavPointListEnd.class}, transition={}), @FSMTransition(state=NavPointNeighboursState.class, symbol={NavPointNeighbourLinkStart.class}, transition={})})
public class NavPointListState
extends AbstractBotFSMState<InfoMessage, TranslatorContext> {
    private boolean begun = false;
    private Map<UnrealId, NavPoint> navPoints = new HashMap<UnrealId, NavPoint>();
    private Map<UnrealId, List<NavPointNeighbourLink>> neighbours = new HashMap<UnrealId, List<NavPointNeighbourLink>>();
    private NavPoint currentNavPoint = null;

    public void stateEntering(TranslatorContext context, IFSMState<InfoMessage, TranslatorContext> fromState, InfoMessage symbol) {
        if (!this.begun) {
            if (!symbol.getClass().equals(NavPointListStart.class)) {
                throw new UnexpectedMessageException(TranslatorMessages.unexpectedMessage(this, (Object)symbol, NavPointListStart.class), context.getLogger(), (Object)this);
            }
            this.begun = true;
            return;
        }
        if (!symbol.getClass().equals(NavPointNeighbourLinkEnd.class)) {
            throw new UnexpectedMessageException(TranslatorMessages.unexpectedMessage(this, (Object)symbol, NavPointNeighbourLinkEnd.class), context.getLogger(), (Object)this);
        }
        this.navPoints.put(this.currentNavPoint.getId(), this.currentNavPoint);
        this.neighbours.put(this.currentNavPoint.getId(), context.getNeighbours());
    }

    public void stateLeaving(TranslatorContext context, IFSMState<InfoMessage, TranslatorContext> toState, InfoMessage symbol) {
        if (symbol.getClass().equals(NavPointNeighbourLinkStart.class)) {
            return;
        }
        if (!symbol.getClass().equals(NavPointListEnd.class)) {
            throw new UnexpectedMessageException(TranslatorMessages.unexpectedMessage(this, (Object)symbol, NavPointListEnd.class), context.getLogger(), (Object)this);
        }
        context.setNavPoints(this.navPoints);
        context.setNavPointLinks(this.neighbours);
        context.processNavPointLinks();
        this.navPoints = new HashMap<UnrealId, NavPoint>(this.navPoints.size() + 20);
        this.neighbours = new HashMap<UnrealId, List<NavPointNeighbourLink>>(this.neighbours.size() + 20);
        this.begun = false;
    }

    public void stateSymbol(TranslatorContext context, InfoMessage symbol) {
        if (!symbol.getClass().equals(NavPoint.class)) {
            throw new UnexpectedMessageException(TranslatorMessages.unexpectedMessage(this, (Object)symbol, NavPoint.class), context.getLogger(), (Object)this);
        }
        this.currentNavPoint = (NavPoint)symbol;
        context.getEventQueue().pushEvent((IWorldChangeEvent)this.currentNavPoint);
    }

    public void init(TranslatorContext context) {
    }

    public void restart(TranslatorContext context) {
        this.currentNavPoint = null;
        this.begun = false;
        this.navPoints = new HashMap<UnrealId, NavPoint>(this.navPoints.size() + 20);
        this.neighbours = new HashMap<UnrealId, List<NavPointNeighbourLink>>(this.neighbours.size() + 20);
    }
}

