/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.udk.communication.translator.server.state;

import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MapListEnd;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MapListStart;
import cz.cuni.amis.pogamut.udk.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.udk.communication.translator.server.support.ServerListState;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.MapListObtained;

/**
 *
 * @author ik
 */
@FSMState(map={@FSMTransition(
					state=ServerRunningState.class,
					symbol={MapListEnd.class},
					transition={})}
)
public class MapListState extends ServerListState<MapList, TranslatorContext> {

	public MapListState() {
		super(MapListStart.class, MapList.class, MapListEnd.class);
	}
	
	@Override
	public void stateLeaving(TranslatorContext context,
			IFSMState<InfoMessage, TranslatorContext> toState, InfoMessage symbol) {
		super.stateLeaving(context, toState, symbol);
		context.getEventQueue().pushEvent(new MapListObtained(getList()));
		newList();
	}
	
	@Override
	protected void innerStateSymbol(TranslatorContext context,
			InfoMessage symbol) {
		super.innerStateSymbol(context, symbol);
		if (symbol instanceof MapList) {
			context.getEventQueue().pushEvent((MapList)symbol);
		}
	}

}

