package cz.cuni.amis.pogamut.udk.communication.translator.bot.transition;

import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.fsm.IFSMTransition;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.udk.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.MapPointListObtained;

public class HandshakeEndTransition implements IFSMTransition<InfoMessage, TranslatorContext> {

	@Override
	public void init(TranslatorContext context) {
	}

	@Override
	public void restart(TranslatorContext context) {
	}

	@Override
	public void stepped(TranslatorContext context,
			IFSMState<InfoMessage, TranslatorContext> fromState,
			InfoMessage bySymbol,
			IFSMState<InfoMessage, TranslatorContext> toState) {
		context.getEventQueue().pushEvent(new MapPointListObtained(context.getNavPoints(), context.getItems()));
	}
	
	@Override
	public String toString() {
		return getClass().getSimpleName();
	}

}
