package cz.cuni.amis.pogamut.udk.bot.impl.test;

import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBotLogicController;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;

import java.util.logging.Level;

public class BotTestLogic extends UDKBotLogicController<UDKBot> {
	
	private BusAwareCountDownLatch latch;
	
	public BusAwareCountDownLatch getLatch() {
		return latch;
	}
	
	@Override
	public void logicInitialize(LogicModule logicModule) {
		super.logicInitialize(logicModule);
		this.latch = new BusAwareCountDownLatch(1, bot.getEventBus(), bot.getWorldView());
	}

	@Override
	public void logic() {
		if (user.isLoggable(Level.WARNING)) user.warning("Logic!");
		latch.countDown();
		if (bot.getWorldView().getSingle(Self.class) == null) {
			throw new RuntimeException("Self not present in the logic!");
		} else {
			if (user.isLoggable(Level.WARNING)) user.warning("Self present.");
		}
	}
	
	@Override
	public void logicShutdown() {
		super.logicShutdown();
		latch = null;
	}

}
