package cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor;

import cz.cuni.amis.pogamut.udk.communication.messages.ItemType;

/**
 * An ammo factory takes care about all items which fall into a {@link ItemType.Category#ARMOR}.
 *
 * @author Jimmy
 */
public class ArmorDescriptorFactory implements IDescriptorFactory<ArmorDescriptor> {

    private static ArmorDescriptorFactory instance = new ArmorDescriptorFactory();

    private ArmorDescriptorFactory() {
    }

    public static ArmorDescriptorFactory getInstance() {
        return instance;
    }

    public ArmorDescriptor getNewDescriptor(ItemTyped configMsg) {
        ArmorDescriptor desc = new ArmorDescriptor();
        desc.doReflexion(configMsg, ArmorDescriptor.class);
        return desc;
    }
}