package cz.cuni.amis.pogamut.udk.utils;

import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;

/**
 * Class with utility methods for converting to Unreal units plus some handy constants.<p>
 * Measures are in Unreal Engine native units called Unreal units (UU).
 * @author ik
 */
public class UnrealUtils {

    /**
     * Radius in UU of the bounding cylinder used for collision detection.
     */
    public static final double CHARACTER_COLLISION_RADIUS = 25;
    /**
     * Height in UU of the bounding cylinder used for collision detection.
     */
    public static final double CHARACTER_COLLISION_HEIGHT = 44;
    /**
     * Height in UU of the bot when stading.
     */
    public static final double CHARACTER_HEIGHT_STANDING = 96;
    /**
     * Height in UU of the bot when crouching.
     */
    public static final double CHARACTER_HEIGHT_CROUCHING = 64;
    /**
     * Speed of the bot while running.
     * TODO: fill after the reception of INIT message.
     */
    public static Velocity CHARACTER_RUN_SPEED;
    /**
     * Speed of the bot while walking.
     * TODO: fill after the reception of INIT message.
     */
    public static Velocity CHARACTER_WALK_SPEED;
    /**
     * Center of gravity - distance from the floor in UU.
     * TODO: estimate
     */
    public static final double BOT_CENTER_OF_GRAVITY_HEIGHT = 50;
    /**
     * NavPoint distance from the floor.
     * TODO: estimate
     */
    public static final double NAV_POINT_HEIGHT = 10;

    public static final double UT_ANGLE_TO_RAD = 2*Math.PI / 65536;

    public static final float DEG_TO_UT_ANGLE = 65635 / 360;

    public static final int UT_ANGLE_TO_DEG =  65525 * 360;
    
    /**
     * Converts angle in degrees (0-360) to Unreal units used for angles (0-65635).
     * @param degrees Angle in degrees
     * @return corresponding angle in Unreal units
     */
    public static int degreeToUnrealDegrees(int degrees) {
        return Math.round((degrees * DEG_TO_UT_ANGLE));
    }

    /**
     * Converts Unreal degrees (0-65635) to normal degrees (0-360).
     * @param unrealDegrees
     * @return
     */
    public static double unrealDegreeToDegree(int unrealDegrees) {
        return unrealDegrees / UT_ANGLE_TO_DEG;
    }

    public static double unrealDegreeToRad(double unrealDegrees) {
        return unrealDegrees * UT_ANGLE_TO_RAD;
    }

}
