package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper;

import org.junit.Assert;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

import cz.cuni.amis.pogamut.udk.communication.worldview.WorldViewTestContext;

import java.util.logging.Level;

/**
 * This class wraps output events, with how many times it should be
 * raised by the worldview.
 * @author Radek 'Black_Hand' Pibil
 *
 */
@XStreamAlias("EventWrapperAndCount")
public class EventWrapperWithCallCount {
	
	@XStreamOmitField
	private int called = 0;
	@XStreamAlias("Wrapper")
	private EventWrapper wrapper;
	@XStreamAsAttribute
	@XStreamAlias("count")
	private final int expectedNumberOfCalls;
	private WorldViewTestContext ctx;
	
	public EventWrapperWithCallCount(WorldViewTestContext ctx, EventWrapper wrapper) {
		this(ctx, wrapper, 1);
	}
	
	public EventWrapperWithCallCount(WorldViewTestContext ctx, EventWrapper wrapper, int expectedNumberOfCalls) {
		this.ctx = ctx;
		this.expectedNumberOfCalls = expectedNumberOfCalls;
		this.wrapper = wrapper;
	}
	
	public int wasCalled() {
		return called;
	}
	
	public boolean hasBeenCalledExpectedNumberOfTimes() {
		return called == expectedNumberOfCalls;
	}		

	public int getCalled() {
		return called;
	}
	
	public EventWrapper getEventWrapper() {
		return wrapper;
	}
	
	/**
	 * The event has just been raised.
	 */
	public void incCalled() {						
		++called;			
		Assert.assertTrue("Event has been raised times more than expected. " +
				wrapper.getExpectedEvent().toString(),
				called <= expectedNumberOfCalls);
		
		if (ctx.isStrictExecution() && hasBeenCalledExpectedNumberOfTimes())
			ctx.incCurrentEventForStrictExecution();
		
		if (ctx.getCurrentEventForStrictExecution() < ctx.getExpectedEventsPlan().size())
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("Next expected event: " +
					ctx.getCurrentMockWrapper().getEventWrapper().getExpectedEvent().toString());
	}
	
	public int getExpectedNumberOfCalls() {
		return expectedNumberOfCalls;
	}
}
