package cz.cuni.amis.pogamut.udk.bot.impl;

import java.util.Random;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.udk.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.udk.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.udk.agent.navigation.UDKAStarPathPlanner;
import cz.cuni.amis.pogamut.udk.agent.navigation.UDKPathExecutor;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotController;
import cz.cuni.amis.pogamut.udk.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.udk.bot.command.AdvancedShooting;
import cz.cuni.amis.pogamut.udk.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.udk.communication.messages.ItemType;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.ItemDescriptor;

/**
 * The most advanced controller that is available. This controller contains all useful modules instantiated.
 * <p><p>
 * Modules currently available:<p>
 * <ol>
 * <li></li>
 * </ol>
 * 
 * @author Jimmy
 *
 * @param <BOT>
 */
public class UDKBotModuleController<BOT extends UDKBot> extends UDKBotLogicController<BOT> {

	/**
	 * Random number generator that is usually useful to have during decision making.
	 */
	protected Random random = new Random(System.currentTimeMillis());
	
	/**
	 * Memory module specialized on general info about the game - game type, time limit, frag limit, etc.
	 * <p><p>
	 * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected Game game;
	
	/**
	 * Memory module specialized on general info about the agent whereabouts - location, rotation, health, current weapon, who is enemy/friend, etc.
	 * <p><p>
	 * May be used since first {@link Self} message is received, i.e, since the first {@link IUDKBotController#botSpawned(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected AgentInfo info;
	
	/**
	 * Memory module specialized on whereabouts of other players - who is visible, enemy / friend, whether bot can see anybody, etc.
	 * <p><p>
	 * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected Players players;
	
	/**
	 * Sensory module that provides mapping between {@link ItemType} and {@link ItemDescriptor} providing
     * an easy way to obtain item descriptors for various items in UDK.
     * <p><p>
     * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected ItemDescriptors descriptors;
	
	/**
	 * Memory module specialized on items on the map - which are visible and which are probably spawned.
	 * <p><p>
	 * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected Items items;
	
	/**
	 * Memory module specialized on agent's senses - whether the bot has been recently killed, collide with level's geometry, etc.
	 * <p><p>
	 * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected Senses senses;
	
	/**
	 * Memory module specialized on info about the bot's weapon and ammo inventory - it can tell you which weapons are loaded, melee/ranged, etc.
	 * <p><p>
	 * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected Weaponry weaponry;
	
	/**
	 * Memory module specialized on the agent's configuration inside UDK - name, vision time, manual spawn, cheats (if enabled at GB2004).
	 * <p><p>
	 * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected AgentConfig config;
	
	/**
	 * Support for creating rays used for raycasting (see {@link AutoTraceRay} that is being utilized).
	 * <p><p>
	 * May be used since {@link IUDKBotController#botInitialized(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
	 */
	protected Raycasting raycasting;
	
	/**
	 * Wraps all available commands that can be issued to the virtual body of the bot inside UDK.
     * <p><p>
     * May be used since since the first {@link IUDKBotController#botSpawned(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected CompleteBotCommandsWrapper body;
	
	/**
	 * Shortcut for <i>body.getAdvancedShooting()</i> that allows you to shoot at opponent.
	 * <p><p>
	 * Note: more weapon-handling methods are available through {@link UDKBotModuleControllerNew#weaponry}.
	 * <p><p>
	 * May be used since since the first {@link IUDKBotController#botSpawned(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
	 * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected AdvancedShooting shoot;
	
	/**
	 * Shortcut for <i>body.getAdvancedLocomotion()</i> that allows you to manually steer the movement through the environment.
	 * <p><p>
	 * Note: navigation is done via {@link UDKBotModuleControllerNew#pathExecutor} that needs {@link PathHandle} from the {@link UDKBotModuleControllerNew#pathPlanner}.
	 * <p><p>
	 * May be used since since the first {@link IUDKBotController#botSpawned(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
	 * Initialized inside {@link UDKBotModuleControllerNew#initializeModules(UDKBot)}.
	 */
	protected AdvancedLocomotion move;
	
	/**
     * Executor is used for following a path in the environment.
     * <p><p>
     * May be used since since the first {@link IUDKBotController#botSpawned(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializePathFinding(UDKBot)}.
     */
	protected IPathExecutor<ILocated> pathExecutor = null;
	
    /**
     * Planner used to compute the path (consisting of navigation points) inside the map.
     * <p><p>
     * May be used since since the first {@link IUDKBotController#botSpawned(cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UDKBotModuleControllerNew#initializePathFinding(UDKBot)}.
     */
    protected IPathPlanner<ILocated> pathPlanner = null;
    
    /**
     * Listener registrator that probes declared methods for the presence of {@link EventListener}, {@link ObjectClassEventListener},
     * {@link ObjectClassListener}, {@link ObjectEventListener} and {@link ObjectListener} annotations and automatically registers
     * them as listeners on a specific events.
     * <p><p>
     * Note that this registrator is usable for 'this' object only! It will work only for 'this' object.
     */
    protected AnnotationListenerRegistrator listenerRegistrator;
    
    /**
     * Shortcut for the {@link UDKBotModuleControllerNew#getWorldView()}.
     */
    protected IVisionWorldView world;
    
    /**
     * Shortcut for the {@link UDKBotModuleControllerNew#getAct()}.
     */
    protected IAct act;
	
    @Override
	public void initializeController(BOT bot) {    	
		super.initializeController(bot);
		world = getWorldView();
		act = getAct();
		initializeModules(bot);
		initializePathFinding(bot);
		initializeListeners(bot);
	}
	
    /**
     * Initializes {@link UDKBotModuleControllerNew#listenerRegistrator} and calls {@link AnnotationListenerRegistrator#addListeners()} method
     * to probe all declared methods for event-annotation presence.
     * @param bot
     */
	protected void initializeListeners(BOT bot) {
		listenerRegistrator = new AnnotationListenerRegistrator(this, getWorldView(), bot.getLogger().getCategory("Listeners"));
		listenerRegistrator.addListeners();
	}

	/**
	 * Initializes path-finding modules: {@link UDKBotModuleControllerNew#pathPlanner} and {@link UDKBotModuleControllerNew#pathExecutor}.
	 * If you need different path planner / path executor - override this method and initialize your own modules.
	 * @param bot
	 */
	protected void initializePathFinding(BOT bot) {
		pathPlanner  = new UDKAStarPathPlanner(bot);
        pathExecutor = new UDKPathExecutor<ILocated>(bot);	        
	}

	/**
	 * Initializes memory/command modules of the bot.
	 * 
	 * @param bot
	 */
	protected void initializeModules(BOT bot) {
		game        = new Game(bot);
		info        = new AgentInfo(bot, game);
		players     = new Players(bot);
		descriptors = new ItemDescriptors(bot);
		items       = new Items(bot, info);
		senses      = new Senses(bot, info, players);
		weaponry    = new Weaponry(bot, descriptors);
		config      = new AgentConfig(bot);
		raycasting  = new Raycasting(bot);
		body        = new CompleteBotCommandsWrapper(bot);		
		shoot       = body.getShooting();
		move        = body.getLocomotion();
	}

}
