/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import java.util.logging.Logger;

public class UDKTimeStuckDetector
implements IStuckDetector {
    private static final double NO_MOVEMENT_SIZE = 10.0;
    private static double DEFAULT_TIMEOUT = 3.0;
    private UDKBot bot;
    private double timeout;
    private SelfListener selfListener;
    private double lastMovementTime = Double.NEGATIVE_INFINITY;
    private boolean stuck = false;
    private Logger log;

    public void setBotWaiting(boolean state) {
    }

    public UDKTimeStuckDetector(UDKBot bot) {
        this(bot, DEFAULT_TIMEOUT);
    }

    public UDKTimeStuckDetector(UDKBot bot, double timeout) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.timeout = timeout;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        if (((Self)event.getObject()).getVelocity().size() > 10.0 || this.lastMovementTime == Double.NEGATIVE_INFINITY) {
            this.lastMovementTime = ((Self)event.getObject()).getLastSeenTime();
        }
        if (((Self)event.getObject()).getLastSeenTime() - this.lastMovementTime >= this.timeout) {
            this.stuck = true;
        }
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public void reset() {
        this.lastMovementTime = Double.NEGATIVE_INFINITY;
        this.stuck = false;
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, (IWorldObjectEventListener)this);
        }

        public void notify(IWorldObjectEvent<Self> event) {
            UDKTimeStuckDetector.this.eventSelf(event);
        }
    }
}

