/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealDataType;

@UnrealDataType
public class Point3D {
    float x;
    float y;
    float z;

    public Point3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Point3D multiply(float a) {
        return new Point3D(this.x * a, this.y * a, this.z * a);
    }

    public Point3D add(Point3D p) {
        return new Point3D(this.x + p.getX(), this.y + p.getY(), this.z + p.getZ());
    }

    public Point3D negateX() {
        return new Point3D(-this.getX(), this.getY(), this.getZ());
    }

    public Point3D negateY() {
        return new Point3D(this.getX(), -this.getY(), this.getZ());
    }

    public Point3D negateXandY() {
        return new Point3D(-this.getX(), -this.getY(), this.getZ());
    }

    public Point3D switchXandY() {
        return new Point3D(this.getY(), this.getX(), this.getZ());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point3D other = (Point3D)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + Float.floatToIntBits(this.x);
        hash = 31 * hash + Float.floatToIntBits(this.y);
        hash = 31 * hash + Float.floatToIntBits(this.z);
        return hash;
    }

    public String toString() {
        return "Point3D{x=" + this.x + "y=" + this.y + "z=" + this.z + '}';
    }
}

