/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.dataobject;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.cuni.amis.nb.pogamut.unreal.timeline.dataobject.TLOpenSupport;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class TLDataObject
extends MultiDataObject {
    private TLDatabase database;
    private IUnrealServer server;
    private SaveDatabase saveDB = new SaveDatabase();
    private final TLDatabase.Adapter changeListener = new TLDatabase.Adapter(){

        @Override
        public void currentTimeChanged(long previousCurrentTime, long currentTime) {
            TLDataObject.this.getCookieSet().assign(SaveCookie.class, (Object[])new SaveCookie[]{TLDataObject.this.saveDB});
            TLDataObject.this.setModified(true);
        }

        @Override
        public void endTimeChanged(long previousEndTime, long endTime) {
            TLDataObject.this.getCookieSet().assign(SaveCookie.class, (Object[])new SaveCookie[]{TLDataObject.this.saveDB});
            TLDataObject.this.setModified(true);
        }
    };

    public TLDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.getCookieSet().assign(SaveCookie.class, (Object[])new SaveCookie[]{this.saveDB});
        this.setModified(true);
        this.database = pf.getSize() > 0L ? this.getDBFromFile(pf) : new TLDatabase();
        CookieSet cookies = this.getCookieSet();
        cookies.assign(TLDatabase.class, (Object[])new TLDatabase[]{this.database});
        cookies.add((Node.Cookie)new TLOpenSupport(this.getPrimaryEntry()));
        cookies.assign(Node.class, (Object[])new Node[]{this.getNodeDelegate()});
        this.database.addDBListener(this.changeListener);
    }

    public IUnrealServer getSourceServer() {
        return this.server;
    }

    public void setSourceServer(IUnrealServer server) {
        this.server = server;
        String mapName = server.getMapName();
        System.out.println("SERVERMAPNAME: " + mapName);
        IUnrealMap map = this.server.getMap();
        map.setName(mapName);
        System.out.println("GETMAPNAME: " + map.getName());
        this.database.setMap(map);
    }

    protected Node createNodeDelegate() {
        return new DataNode((DataObject)this, Children.LEAF, this.getLookup());
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public TLDatabase getDatabase() {
        return this.database;
    }

    public String getMapName() {
        return this.database.getMap().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLDatabase getDBFromFile(FileObject pf) throws FileNotFoundException, IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(FileUtil.toFile((FileObject)pf));
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            TLDatabase db = (TLDatabase)xstream.fromXML((InputStream)in);
            db.printInfo(System.out);
            TLDatabase tLDatabase = db;
            return tLDatabase;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private class SaveDatabase
    implements SaveCookie {
        private SaveDatabase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws IOException {
            XStream xstream = new XStream();
            FileLock lock = TLDataObject.this.getPrimaryFile().lock();
            OutputStream stream = null;
            try {
                stream = TLDataObject.this.getPrimaryFile().getOutputStream(lock);
                xstream.toXML((Object)TLDataObject.this.getDatabase(), stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                lock.releaseLock();
            }
            TLDataObject.this.getCookieSet().assign(SaveCookie.class, (Object[])new SaveCookie[0]);
            TLDataObject.this.setModified(false);
        }
    }
}

