/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.GLUT;
import cz.cuni.amis.nb.pogamut.unreal.map.BlendTriangle;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.GLRendererCollection;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.GlColor;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IRenderableUTAgent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.MapRenderer;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.MapViewpoint;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.Point;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Vector3d;

public class EnvironmentRenderer
implements GLEventListener {
    private static Logger logger = Logger.getLogger("EnvironmentRenderer");
    private static GLU glu = new GLU();
    private static GLUT glut = new GLUT();
    private MapViewpoint viewpoint;
    private GLRendererCollection<IRenderableUTAgent> agentRenderes;
    private MapRenderer mapRenderer;
    int loops = 0;
    private boolean selectDirtyFlag = true;
    private Point selectPoint = new Point();
    private int[] selectedObjects = new int[0];
    SelectionHit hi = new SelectionHit(this.loops);

    public EnvironmentRenderer(MapViewpoint viewpoint, GLRendererCollection<IRenderableUTAgent> agentRenderes, MapRenderer mapRenderer) {
        this.viewpoint = viewpoint;
        this.agentRenderes = agentRenderes;
        this.mapRenderer = mapRenderer;
    }

    public synchronized void init(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glEnable(2929);
        gl.glBlendFunc(770, 771);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glShadeModel(7425);
        gl.glDisable(2896);
        this.agentRenderes.prepare(gl);
        this.mapRenderer.prepare(gl);
    }

    public synchronized void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        this.setProjection(gl, x, y, width, height);
    }

    private synchronized void setProjection(GL gl, int x, int y, int width, int height) {
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluPerspective(this.viewpoint.getViewAngle(), (double)h, 10.0, 100000.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    private synchronized void prepareCanvas(GL gl) {
        gl.glEnable(2929);
        gl.glClearColor(0.45f, 0.45f, 0.45f, 0.0f);
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        Location observerLoc = this.viewpoint.getLocation();
        Location eyeLoc = this.viewpoint.getEye();
        Vector3d upVec = this.viewpoint.getUp();
        glu.gluLookAt(eyeLoc.x, eyeLoc.y, eyeLoc.z, observerLoc.x, observerLoc.y, observerLoc.z, upVec.x, upVec.y, upVec.z);
        gl.glScaled(1.0, 1.0, -1.0);
    }

    public synchronized void display(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        int[] selectBufferArray = new int[512];
        IntBuffer selectBuffer = BufferUtil.newIntBuffer((int)selectBufferArray.length);
        gl.glSelectBuffer(selectBufferArray.length, selectBuffer);
        gl.glRenderMode(7170);
        gl.glInitNames();
        gl.glPushName(-1);
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        glu.gluPickMatrix((double)this.selectPoint.x, (double)(viewport[3] - this.selectPoint.y), 1.0, 1.0, viewport, 0);
        glu.gluPerspective(this.viewpoint.getViewAngle(), (double)((float)viewport[2] / (float)viewport[3]), 10.0, 100000.0);
        this.prepareCanvas(gl);
        this.mapRenderer.render(gl);
        this.agentRenderes.render(gl);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        int numOfHits = gl.glRenderMode(7168);
        selectBuffer.get(selectBufferArray);
        this.selectedObjects = new int[numOfHits];
        for (int hitIndex = 0; hitIndex < numOfHits; ++hitIndex) {
            this.selectedObjects[hitIndex] = selectBufferArray[hitIndex * 4 + 3];
        }
        this.selectDirtyFlag = false;
        this.prepareCanvas(gl);
        this.mapRenderer.render(gl);
        this.agentRenderes.render(gl);
        gl.glEnable(3042);
        gl.glEnable(2896);
        gl.glBegin(4);
        List<BlendTriangle> blendPolys = this.painterSort(this.mapRenderer.getBlendedTris());
        for (BlendTriangle triangle : blendPolys) {
            for (int i = 0; i < 3; ++i) {
                GlColor col = triangle.getVerts()[i].getColor();
                gl.glColor4d(col.r, col.g, col.b, col.a);
                Location loc = triangle.getVerts()[i].getLocation();
                gl.glVertex3d(loc.x, loc.y, loc.z);
            }
        }
        gl.glEnd();
        gl.glDisable(2896);
        gl.glDisable(3042);
        String res = "[" + this.selectPoint.x + ", " + this.selectPoint.y + "] # " + numOfHits;
        for (int objId : this.selectedObjects) {
            res = res + ":" + objId;
        }
        this.renderText(gl, res, 0, 0, 7);
        ++this.loops;
    }

    private List<BlendTriangle> painterSort(List<BlendTriangle> orgPolys) {
        LinkedList<BlendTriangle> polys = new LinkedList<BlendTriangle>(orgPolys);
        final Location eyeLoc = this.viewpoint.getEye();
        Collections.sort(polys, new Comparator<BlendTriangle>(){

            @Override
            public int compare(BlendTriangle o1, BlendTriangle o2) {
                if (this.maxDistance(o1) < this.maxDistance(o2)) {
                    return -1;
                }
                if (this.maxDistance(o1) > this.maxDistance(o2)) {
                    return 1;
                }
                return 0;
            }

            private double maxDistance(BlendTriangle tri) {
                double max = Double.MIN_VALUE;
                for (int i = 0; i < 3; ++i) {
                    Location vertloc = tri.getVerts()[i].getLocation();
                    if (!(Location.getDistance((Location)vertloc, (Location)eyeLoc) > max)) continue;
                    max = Location.getDistance((Location)vertloc, (Location)eyeLoc);
                }
                return max;
            }
        });
        return polys;
    }

    private void renderText(GL gl, String text, int x, int y, int font) {
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)viewport[2], 0.0, (double)viewport[3], -1.0, 1.0);
        gl.glColor3d(1.0, 1.0, 1.0);
        gl.glRasterPos3d(0.0, 0.0, 0.0);
        glut.glutBitmapString(font, text);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
    }

    private void glErrorTest(GL gl, String text) {
        int glError = gl.glGetError();
        if (glError != 0 && logger.isLoggable(Level.SEVERE)) {
            logger.severe("GL ERROR: " + text + " - " + glu.gluErrorString(glError));
        }
    }

    public synchronized int[] getSelectedObjects() throws IllegalStateException {
        if (this.selectDirtyFlag) {
            throw new IllegalStateException("Not objects from selected point. Did you call display() after setSelectPoint()?");
        }
        return Arrays.copyOf(this.selectedObjects, this.selectedObjects.length);
    }

    public synchronized void setSelectPoint(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Point cannot be null");
        }
        this.selectPoint = new Point(point);
        this.selectDirtyFlag = true;
    }

    public static class SelectionHit {
        private SelectionHit(int z) {
        }
    }
}

