/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import cz.cuni.amis.nb.pogamut.options.TimelinePanel;
import cz.cuni.amis.nb.pogamut.unreal.map.BlendTriangle;
import cz.cuni.amis.nb.pogamut.unreal.map.BlendVertex;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.GlColor;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.ISubGLRenderer;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.Box;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMapInfo;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealWaylink;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealWaypoint;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import org.openide.util.NbPreferences;

public class MapRenderer
implements ISubGLRenderer<IUnrealMap>,
PreferenceChangeListener {
    private GLU glu = new GLU();
    public final int GRID_SCALE = 1000;
    public final double NAVPOINT_RADIUS = 30.0;
    private int gridList = -1;
    private int pathDisplayList = -1;
    private int waypointDisplayList = -1;
    private int backgroundList = -1;
    private boolean updateLists = true;
    private IUnrealMap map;
    private List<PathTriangle> pathTris;
    private List<BlendTriangle> waypointsTris;
    private int glName;

    public MapRenderer(IUnrealMap map, int glName) {
        this.map = map;
        this.glName = glName;
        NbPreferences.forModule(TimelinePanel.class).addPreferenceChangeListener(this);
    }

    @Override
    public IUnrealMap getObject() {
        return this.map;
    }

    @Override
    public void prepare(GL gl) {
        this.gridList = this.createGridList(gl);
        this.backgroundList = this.createMapBackground(gl);
        this.waypointsTris = this.createWaypointsList();
        this.pathTris = this.createPathsList();
    }

    public int createMapBackground(GL gl) {
        IUnrealMapInfo info = this.map.getInfo();
        if (info == null) {
            return -1;
        }
        Location[] pos2D = info.getImagePoints();
        Location[] posMap = info.getWorldPoints();
        for (int i = 0; i < posMap.length; ++i) {
            posMap[i] = posMap[i].setZ(0.0);
        }
        Location vec1stTo2nd = Location.sub((Location)pos2D[1], (Location)pos2D[0]);
        Location vec1stTo3rd = Location.sub((Location)pos2D[2], (Location)pos2D[0]);
        Coeficients[] coef = new Coeficients[]{this.solveEquation(new Location(0.0, 0.0, 0.0), pos2D[0], vec1stTo2nd, vec1stTo3rd), this.solveEquation(new Location((double)info.getWidth(), 0.0, 0.0), pos2D[0], vec1stTo2nd, vec1stTo3rd), this.solveEquation(new Location((double)info.getWidth(), (double)info.getHeight(), 0.0), pos2D[0], vec1stTo2nd, vec1stTo3rd), this.solveEquation(new Location(0.0, (double)info.getHeight(), 0.0), pos2D[0], vec1stTo2nd, vec1stTo3rd)};
        Location map1stTo2nd = Location.sub((Location)posMap[1], (Location)posMap[0]);
        Location map1stTo3rd = Location.sub((Location)posMap[2], (Location)posMap[0]);
        Location[] mapLoc = new Location[4];
        for (int i = 0; i < 4; ++i) {
            mapLoc[i] = Location.add((Location)posMap[0], (Location)Location.add((Location)map1stTo2nd.scale(coef[i].a), (Location)map1stTo3rd.scale(coef[i].b)));
        }
        int texture = this.genTexture(gl);
        gl.glBindTexture(3553, texture);
        this.glu.gluBuild2DMipmaps(3553, 32849, info.getWidth(), info.getHeight(), 6407, 5121, (Buffer)ByteBuffer.wrap(info.getImgRGBData()));
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10240, 9729);
        int list = gl.glGenLists(1);
        gl.glNewList(list, 4864);
        gl.glEnable(3553);
        gl.glBindTexture(3553, texture);
        gl.glBegin(7);
        gl.glColor3d(1.0, 1.0, 1.0);
        int i = 0;
        double z = this.getFloorZ() + 5.0;
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex3d(mapLoc[i].x, mapLoc[i].y, z);
        i = 1;
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex3d(mapLoc[i].x, mapLoc[i].y, z);
        i = 2;
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex3d(mapLoc[i].x, mapLoc[i].y, z);
        i = 3;
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex3d(mapLoc[i].x, mapLoc[i].y, z);
        gl.glEnd();
        gl.glDisable(3553);
        gl.glEndList();
        return list;
    }

    private int genTexture(GL gl) {
        int[] textures = new int[1];
        gl.glGenTextures(1, textures, 0);
        return textures[0];
    }

    private double getFloorZ() {
        Box box = this.map.getBox();
        return box.minZ - box.getMinDelta() * 0.2;
    }

    private double getGridZ() {
        Box box = this.map.getBox();
        return box.minZ - box.getMinDelta() * 0.35;
    }

    private Coeficients solveEquation(Location r, Location p, Location u, Location v) {
        if (u.x != 0.0) {
            double multi = u.y / u.x;
            double b = -(p.y - r.y - (p.x - r.x) * multi) / (v.y - v.x * multi);
            double a = -(p.x - r.x + b * v.x) / u.x;
            return new Coeficients(a, b);
        }
        double b = (r.x - p.x) / v.x;
        double a = (r.y - p.y - b * v.y) / u.y;
        return new Coeficients(a, b);
    }

    private LinkedList<BlendTriangle> createWaypointsList() {
        LinkedList<BlendTriangle> triangles = new LinkedList<BlendTriangle>();
        Collection navs = this.map.vertexSet();
        GlColor color = new GlColor(new Color(NbPreferences.forModule(TimelinePanel.class).getInt(TimelinePanel.MapColor.WAYPOINTS_COLOR_KEY.getPrefKey(), TimelinePanel.MapColor.WAYPOINTS_COLOR_KEY.getDegaultARGB())));
        for (IUnrealWaypoint nav : navs) {
            Location loc = nav.getLocation();
            Location[] points = this.createCirclePoints(loc, 30.0);
            for (int pointIndex = 0; pointIndex < points.length; ++pointIndex) {
                BlendTriangle triangle = new BlendTriangle();
                triangle.setVertex(0, loc, color);
                triangle.setVertex(1, points[pointIndex], color);
                triangle.setVertex(2, points[(pointIndex + 1) % points.length], color);
                triangles.add(triangle);
            }
        }
        return triangles;
    }

    private Location[] createCirclePoints(Location loc, double radius) {
        Location[] points = new Location[12];
        double stepAngle = Math.PI * 2 / (double)points.length;
        for (int pointIndex = 0; pointIndex < points.length; ++pointIndex) {
            double angle = stepAngle * (double)pointIndex;
            double xPos = loc.x + radius * Math.cos(angle);
            double yPos = loc.y + radius * Math.sin(angle);
            points[pointIndex] = new Location(xPos, yPos, loc.z);
        }
        return points;
    }

    private int createGridList(GL gl) {
        Box mapBox = this.map.getBox();
        int numMainLines = this.getNumGridLines(mapBox);
        double lineLength = 2000 * numMainLines;
        double floorZ = this.getGridZ();
        int list = gl.glGenLists(1);
        gl.glNewList(list, 4864);
        gl.glBegin(1);
        double minY = mapBox.getCenterY() - lineLength / 2.0;
        double maxY = mapBox.getCenterY() + lineLength / 2.0;
        gl.glColor3d(0.45, 0.29, 0.32);
        gl.glVertex3d(mapBox.getCenterX(), minY, floorZ);
        gl.glVertex3d(mapBox.getCenterX(), maxY, floorZ);
        double minX = mapBox.getCenterX() - lineLength / 2.0;
        double maxX = mapBox.getCenterX() + lineLength / 2.0;
        gl.glColor3d(0.3, 0.57, 0.31);
        gl.glVertex3d(minX, mapBox.getCenterY(), floorZ);
        gl.glVertex3d(maxX, mapBox.getCenterY(), floorZ);
        for (int line = 1; line <= numMainLines; ++line) {
            for (int coef = -1; coef <= 1; coef += 2) {
                gl.glColor3d(0.34, 0.34, 0.34);
                gl.glVertex3d(mapBox.getCenterX() + (double)(coef * line * 1000), minY, floorZ);
                gl.glVertex3d(mapBox.getCenterX() + (double)(coef * line * 1000), maxY, floorZ);
                gl.glVertex3d(minX, mapBox.getCenterY() + (double)(coef * line * 1000), floorZ);
                gl.glVertex3d(maxX, mapBox.getCenterY() + (double)(coef * line * 1000), floorZ);
                gl.glColor3d(0.41, 0.41, 0.41);
                for (int minority = 1; minority < 10; ++minority) {
                    gl.glVertex3d(mapBox.getCenterX() + (double)(coef * ((line - 1) * 1000 + minority * 1000 / 10)), minY, floorZ);
                    gl.glVertex3d(mapBox.getCenterX() + (double)(coef * ((line - 1) * 1000 + minority * 1000 / 10)), maxY, floorZ);
                    gl.glVertex3d(minX, mapBox.getCenterY() + (double)(coef * ((line - 1) * 1000 + minority * 1000 / 10)), floorZ);
                    gl.glVertex3d(maxX, mapBox.getCenterY() + (double)(coef * ((line - 1) * 1000 + minority * 1000 / 10)), floorZ);
                }
            }
        }
        gl.glEnd();
        gl.glEndList();
        return list;
    }

    private int getNumGridLines(Box mapBox) {
        double max = mapBox.getDeltaX() > mapBox.getDeltaY() ? mapBox.getDeltaX() : mapBox.getDeltaY();
        return (int)Math.ceil((max /= 2.0) / 1000.0);
    }

    private Location[] createQuadPath(IUnrealWaylink path) {
        Location[] quads = new Location[12];
        IUnrealWaypoint from = path.getStart();
        IUnrealWaypoint to = path.getEnd();
        Location fromLoc = from.getLocation();
        Location toLoc = to.getLocation();
        Location dir = Location.sub((Location)toLoc, (Location)fromLoc).setZ(0.0);
        dir = dir.getNormalized();
        Location trans = new Location(dir.y, -dir.x, 0.0);
        quads[0] = Location.add((Location)fromLoc, (Location)trans.scale(30.0));
        quads[1] = Location.add((Location)quads[0], (Location)dir.scale(30.0));
        quads[2] = Location.add((Location)quads[1], (Location)trans.scale(-60.0));
        quads[3] = Location.add((Location)quads[2], (Location)dir.scale(-30.0));
        quads[4] = Location.add((Location)toLoc, (Location)trans.scale(-30.0));
        quads[5] = Location.add((Location)quads[4], (Location)dir.scale(-30.0));
        quads[6] = Location.add((Location)quads[5], (Location)trans.scale(60.0));
        quads[7] = Location.add((Location)quads[6], (Location)dir.scale(30.0));
        quads[8] = quads[2];
        quads[9] = quads[1];
        quads[10] = quads[6];
        quads[11] = quads[5];
        return quads;
    }

    private LinkedList<PathTriangle> createPathsList() {
        LinkedList<PathTriangle> triangles = new LinkedList<PathTriangle>();
        Set paths = this.map.edgeSet();
        double deltaZ = this.map.getBox().getDeltaZ();
        double displaceZ = this.map.getBox().minZ;
        for (IUnrealWaylink path : paths) {
            Location[] quads = this.createQuadPath(path);
            GlColor lowColor = new GlColor(0.8, 0.8, 0.8);
            GlColor highColor = new GlColor(0.8, 0.0, 0.0);
            int quadNum = quads.length / 4;
            for (int quad = 0; quad < quadNum; ++quad) {
                PathTriangle triOne = new PathTriangle(path.getFlags());
                for (int i = 0; i < 3; ++i) {
                    Location vertexLoc = quads[quad * 4 + i];
                    GlColor color = lowColor.getMixedWith(highColor, (vertexLoc.z - displaceZ) / deltaZ);
                    triOne.setVertex(i, vertexLoc, color);
                }
                PathTriangle triTwo = new PathTriangle(path.getFlags());
                for (int i = 0; i < 3; ++i) {
                    int quadIndex = quad * 4 + (i + 2) % 4;
                    Location vertexLoc = quads[quadIndex];
                    GlColor color = lowColor.getMixedWith(highColor, (vertexLoc.z - displaceZ) / deltaZ);
                    triTwo.setVertex(i, vertexLoc, color);
                }
                triangles.add(triOne);
                triangles.add(triTwo);
            }
        }
        return triangles;
    }

    @Override
    public synchronized void render(GL gl) {
        if (this.updateLists || !gl.glIsList(this.waypointDisplayList) || !gl.glIsList(this.pathDisplayList)) {
            this.updateMapDisplayLists(gl);
            this.updateLists = false;
        }
        gl.glLoadName(this.glName);
        gl.glShadeModel(7424);
        gl.glCallList(this.gridList);
        gl.glCallList(this.backgroundList);
        gl.glCallList(this.pathDisplayList);
        gl.glCallList(this.waypointDisplayList);
        gl.glLoadName(-1);
    }

    private synchronized void renderPaths(GL gl, List<PathTriangle> triangles) {
        GlColor lowColor = new GlColor(new Color(NbPreferences.forModule(TimelinePanel.class).getInt(TimelinePanel.MapColor.LOW_COLOR_KEY.getPrefKey(), TimelinePanel.MapColor.LOW_COLOR_KEY.getDegaultARGB())));
        GlColor highColor = new GlColor(new Color(NbPreferences.forModule(TimelinePanel.class).getInt(TimelinePanel.MapColor.HIGH_COLOR_KEY.getPrefKey(), TimelinePanel.MapColor.HIGH_COLOR_KEY.getDegaultARGB())));
        boolean includeFlagBehavior = NbPreferences.forModule(TimelinePanel.class).getBoolean("includeFlagToRendering", true);
        double deltaZ = this.map.getBox().getDeltaZ();
        double displaceZ = this.map.getBox().minZ;
        gl.glEnable(2903);
        gl.glShadeModel(7425);
        gl.glBegin(4);
        for (PathTriangle triangle : triangles) {
            boolean render = false;
            render = includeFlagBehavior ? this.includeCanRenderPathFlag(triangle.getFlags()) : this.excludeCanRenderFlag(triangle.getFlags());
            if (!render) continue;
            for (BlendVertex v : triangle.getVerts()) {
                Location vertexLoc = v.getLocation();
                GlColor color = lowColor.getMixedWith(highColor, (vertexLoc.z - displaceZ) / deltaZ);
                gl.glColor4d(color.r, color.g, color.b, color.a);
                gl.glVertex3d(vertexLoc.x, vertexLoc.y, vertexLoc.z);
            }
        }
        gl.glEnd();
    }

    private synchronized boolean includeCanRenderPathFlag(int testedFlag) {
        for (TimelinePanel.MapFlag flag : TimelinePanel.MapFlag.values()) {
            boolean shouldRender;
            if ((flag.getFlag() & testedFlag) == 0 || !(shouldRender = NbPreferences.forModule(TimelinePanel.class).getBoolean(flag.getPrefKey(), flag.getDefault()))) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean excludeCanRenderFlag(int testedFlag) {
        for (TimelinePanel.MapFlag flag : TimelinePanel.MapFlag.values()) {
            boolean shouldRender;
            if ((flag.getFlag() & testedFlag) == 0 || (shouldRender = NbPreferences.forModule(TimelinePanel.class).getBoolean(flag.getPrefKey(), flag.getDefault()))) continue;
            return false;
        }
        return true;
    }

    private synchronized void renderWaypoints(GL gl, List<BlendTriangle> triangles) {
        GlColor color = new GlColor(new Color(NbPreferences.forModule(TimelinePanel.class).getInt(TimelinePanel.MapColor.WAYPOINTS_COLOR_KEY.getPrefKey(), TimelinePanel.MapColor.WAYPOINTS_COLOR_KEY.getDegaultARGB())));
        gl.glEnable(2903);
        gl.glShadeModel(7425);
        gl.glBegin(4);
        for (BlendTriangle triangle : triangles) {
            for (BlendVertex v : triangle.getVerts()) {
                gl.glColor4d(color.r, color.g, color.b, color.a);
                gl.glVertex3d(v.getLocation().x, v.getLocation().y, v.getLocation().z + 0.1);
            }
        }
        gl.glEnd();
    }

    @Override
    public synchronized void preferenceChange(PreferenceChangeEvent evt) {
        this.updateLists = true;
    }

    private synchronized void updateMapDisplayLists(GL gl) {
        gl.glDeleteLists(this.pathDisplayList, 1);
        gl.glDeleteLists(this.waypointDisplayList, 1);
        this.pathDisplayList = gl.glGenLists(1);
        gl.glNewList(this.pathDisplayList, 4864);
        this.renderPaths(gl, this.pathTris);
        gl.glEndList();
        this.waypointDisplayList = gl.glGenLists(1);
        gl.glNewList(this.waypointDisplayList, 4864);
        this.renderWaypoints(gl, this.waypointsTris);
        gl.glEndList();
    }

    @Override
    public List<BlendTriangle> getBlendedTris() {
        LinkedList<BlendTriangle> list = new LinkedList<BlendTriangle>();
        return list;
    }

    public void destroy() {
        NbPreferences.forModule(TimelinePanel.class).removePreferenceChangeListener(this);
    }

    private static class PathTriangle
    extends BlendTriangle {
        private int flags;

        public PathTriangle(int flags) {
            this.flags = flags;
        }

        public int getFlags() {
            return this.flags;
        }
    }

    private static class Coeficients {
        double a;
        double b;

        public Coeficients(double a, double b) {
            this.a = a;
            this.b = b;
        }
    }
}

