/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import cz.cuni.amis.nb.pogamut.unreal.map.BlendTriangle;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.ISubGLRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL;

public class GLRendererCollection<T>
implements ISubGLRenderer<GLRendererCollection<T>> {
    private List<ISubGLRenderer<T>> renderers = Collections.synchronizedList(new ArrayList());

    public synchronized void addSubRenderer(ISubGLRenderer<T> subrenderer) {
        this.renderers.add(subrenderer);
    }

    public synchronized boolean removeSubRenderer(ISubGLRenderer<T> subrenderer) {
        return this.renderers.remove(subrenderer);
    }

    public synchronized List<ISubGLRenderer<T>> getSubRenderes() {
        return Collections.unmodifiableList(new ArrayList<ISubGLRenderer<T>>(this.renderers));
    }

    public synchronized List<ISubGLRenderer<T>> getRenderersOf(T o) {
        ArrayList<ISubGLRenderer<T>> result = new ArrayList<ISubGLRenderer<T>>();
        for (ISubGLRenderer<T> renderer : this.renderers) {
            if (renderer.getObject() != o) continue;
            result.add(renderer);
        }
        return result;
    }

    public synchronized void removeRenderersOf(T o) {
        List<ISubGLRenderer<T>> renderersOf = this.getRenderersOf(o);
        for (ISubGLRenderer<T> renderer : renderersOf) {
            this.removeSubRenderer(renderer);
        }
    }

    public synchronized Set<T> getDrawnObjects() {
        HashSet<T> set = new HashSet<T>();
        for (ISubGLRenderer<T> renderer : this.renderers) {
            set.add(renderer.getObject());
        }
        return set;
    }

    @Override
    public synchronized void render(GL gl) {
        ISubGLRenderer[] renderersArray;
        for (ISubGLRenderer subrenderer : renderersArray = this.renderers.toArray(new ISubGLRenderer[0])) {
            subrenderer.render(gl);
        }
    }

    @Override
    public GLRendererCollection<T> getObject() {
        return this;
    }

    @Override
    public synchronized void prepare(GL gl) {
        for (ISubGLRenderer<T> renderer : this.renderers) {
            renderer.prepare(gl);
        }
    }

    @Override
    public synchronized List<BlendTriangle> getBlendedTris() {
        ISubGLRenderer[] renderersArray;
        LinkedList<BlendTriangle> list = new LinkedList<BlendTriangle>();
        for (ISubGLRenderer subrenderer : renderersArray = this.renderers.toArray(new ISubGLRenderer[0])) {
            list.addAll(subrenderer.getBlendedTris());
        }
        return list;
    }
}

