/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.pogamut.base.utils.logging.marks.LogMapMark;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.io.Serializable;
import java.util.logging.LogRecord;
import java.util.zip.DataFormatException;

public class MapEvent
implements Serializable {
    private TLEntity entity;
    private LogRecord record;
    private LogMapMark mapMark;
    private LogRecord closingRecord = null;

    MapEvent(TLEntity entity, LogRecord record) throws DataFormatException {
        this.record = record;
        this.entity = entity;
        for (Object parameter : record.getParameters()) {
            if (!(parameter instanceof LogMapMark)) continue;
            this.mapMark = (LogMapMark)parameter;
            return;
        }
        throw new DataFormatException("LogRecord " + record.toString() + " doesn't have a log map event as parameter.");
    }

    MapEvent(TLEntity entity, LogRecord record, LogMapMark mark) {
        this.entity = entity;
        this.record = record;
        this.mapMark = mark;
    }

    public String getMessage() {
        return this.mapMark.getMessage();
    }

    public LogMapMark getMark() {
        return this.mapMark;
    }

    public long getStartTS() {
        return this.record.getMillis();
    }

    public long getDuration() {
        if (this.mapMark.getType() == LogMapMark.Type.START_EVENT) {
            if (this.closingRecord == null) {
                return Integer.MAX_VALUE;
            }
            return this.closingRecord.getMillis() - this.record.getMillis();
        }
        return this.mapMark.getDuration();
    }

    void recievedClosingRecord(LogRecord endingRecord) {
        this.closingRecord = endingRecord;
    }

    public boolean timeframeContains(long time) {
        if (time < this.getStartTS()) {
            return false;
        }
        return time <= this.getStartTS() + this.getDuration();
    }

    public boolean shouldFollowPlayer() {
        return this.mapMark.getLocation() == null;
    }

    public Location getLocation(long time) {
        return new Location(this.mapMark.getLocation(this.entity.getLocation(time)));
    }
}

