/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.map;

import cz.cuni.amis.nb.pogamut.unreal.map.MapColorGenerator;
import cz.cuni.amis.nb.pogamut.unreal.map.ProxyRenderableAgent;
import cz.cuni.amis.nb.pogamut.unreal.map.SelectableMapGLPanel;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IRenderableUTAgent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.UTAgentSubGLRenderer;
import cz.cuni.amis.pogamut.unreal.bot.IUnrealBot;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import java.util.Collection;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class PureMapGLPanel
extends SelectableMapGLPanel
implements CollectionEventListener<IUnrealBot> {
    protected IUnrealServer server;
    protected MapColorGenerator colorGenerator;
    private Timer timer;
    private final int REDRAW_DELAY = 250;

    protected PureMapGLPanel(IUnrealMap map, IUnrealServer server) {
        super(map, Logger.getLogger("PureMapGLPanel"));
        this.server = server;
        this.colorGenerator = new MapColorGenerator();
        for (Object agent : server.getAgents()) {
            this.addAgentRenderer((IUnrealBot)agent);
        }
        for (Object agent : server.getNativeAgents()) {
            this.addAgentRenderer((IUnrealBot)agent);
        }
        server.getAgents().addCollectionListener((CollectionEventListener)this);
        server.getNativeAgents().addCollectionListener((CollectionEventListener)this);
    }

    public synchronized void startDisplayLoop() {
        if (this.timer == null) {
            this.timer = new Timer("Overview map redrawer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PureMapGLPanel.this.display();
                }
            }, 250L, 250L);
        }
    }

    public synchronized void stopDisplayLoop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void addAgentRenderer(IUnrealBot agent) {
        ProxyRenderableAgent renderableUTAgent = new ProxyRenderableAgent(agent, this.colorGenerator.getUniqueColor(), this.lastGLName++);
        this.agentRenderes.addSubRenderer(new UTAgentSubGLRenderer(renderableUTAgent, this.getMap()));
    }

    private void removeAgentRenderer(IUnrealBot agent) {
        Set drawnAgent = this.agentRenderes.getDrawnObjects();
        for (IRenderableUTAgent renderableAgent : drawnAgent) {
            if (renderableAgent.getDataSource() != agent) continue;
            this.agentRenderes.removeRenderersOf(renderableAgent);
        }
    }

    public void preAddEvent(Collection<IUnrealBot> toBeAdded, Collection<IUnrealBot> whereToAdd) {
    }

    public synchronized void postAddEvent(Collection<IUnrealBot> alreadyAdded, Collection<IUnrealBot> whereWereAdded) {
        for (IUnrealBot agent : alreadyAdded) {
            this.addAgentRenderer(agent);
        }
    }

    public synchronized void preRemoveEvent(Collection<IUnrealBot> toBeRemoved, Collection<IUnrealBot> whereToRemove) {
        for (IUnrealBot removedAgent : toBeRemoved) {
            this.removeAgentRenderer(removedAgent);
        }
    }

    public void postRemoveEvent(Collection<IUnrealBot> alreadyAdded, Collection<IUnrealBot> whereWereRemoved) {
    }

    @Override
    public synchronized void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.server.getAgents().removeCollectionListener((CollectionEventListener)this);
        this.server.getNativeAgents().removeCollectionListener((CollectionEventListener)this);
        this.server = null;
        super.destroy();
    }
}

