/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TLProperty<T>
implements Serializable {
    private String name;
    private Class type = null;
    private List<Record> values = Collections.synchronizedList(new LinkedList());
    private long lastTimestamp = 0L;

    public TLProperty(String name, Class propertyType) {
        this.name = name;
        this.type = propertyType;
    }

    public synchronized Object getValue() {
        Record tail = this.getLast();
        if (tail == null) {
            return null;
        }
        return tail.value;
    }

    public synchronized T getValue(long time) {
        T last = null;
        for (Record record : this.values) {
            if (record.timestamp > time) break;
            last = record.value;
        }
        return last;
    }

    public void setValue(Object arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Class getType() {
        return this.type;
    }

    public synchronized void addValue(Object value, long timestamp) {
        if (this.values.size() == 0) {
            this.values.add(new Record<Object>(value, timestamp));
            this.lastTimestamp = timestamp;
            return;
        }
        if (this.getLastTS() >= timestamp) {
            throw new UnsupportedOperationException("Value can be added only to the end.");
        }
        Record tail = this.values.get(this.values.size() - 1);
        Record<Object> newRecord = new Record<Object>(value, timestamp);
        if (tail.value == null ? newRecord.value == null : tail.value.equals(value)) {
            this.lastTimestamp = timestamp;
        } else {
            this.values.add(newRecord);
        }
    }

    private long getLastTS() {
        return this.lastTimestamp;
    }

    public List<Record> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    protected synchronized Record getLast() {
        if (this.values.size() == 0) {
            return null;
        }
        return this.values.get(this.values.size() - 1);
    }

    public String getName() {
        return this.name;
    }

    public void printDebug() {
        System.out.println("Variable " + this.getName());
        Calendar calendar = Calendar.getInstance();
        LinkedList<Record> lst = new LinkedList<Record>(this.values);
        for (Record record : lst) {
            calendar.setTimeInMillis(record.timestamp);
            System.out.println(" * " + calendar.getTime() + " " + record.value);
        }
    }

    public static class Record<T>
    implements Serializable {
        long timestamp;
        T value;

        public Record(T value, long timestamp) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

